# -*- coding:utf-8 -*-
from django.db import models
from datetime import datetime

from django.conf import settings


class LogCmd(models.Model):
    reqid    = models.BigIntegerField(default=0, db_index=True)
    logtime  = models.DateTimeField(db_index = True)
    ip       = models.CharField( max_length = 16, default='' )
    login    = models.CharField( max_length = 50, default='' )
    cmd      = models.CharField( max_length = 50, default='' )
    path     = models.CharField( max_length = 50, default='' )
    param    = models.CharField( max_length = 4096, default='' )
    http_status = models.IntegerField(default=0)

    def save(self, *args, **kwargs):
            self.logtime = datetime.now()
            super(LogCmd, self).save(*args, **kwargs)
    def __unicode__(self):
        return "%s %s %s" % (self.logtime, self.login, self.path)
