# -*- coding:utf-8 -*-

import unittest
from tools import *

"""
запуск:
python logcmd/tests.py
"""

class SimpleTest(unittest.TestCase):
    def test_path(self):
        self.failUnlessEqual(parse_request_path('?aaa')['path'], '')
        self.failUnlessEqual(parse_request_path('bbb?aaa')['path'], 'bbb')
        self.failUnlessEqual(parse_request_path('/bbb?aaa')['path'], '/bbb')
        self.failUnlessEqual(parse_request_path('/bbb/ccc?aaa')['path'], '/bbb/ccc')
        self.failUnlessEqual(parse_request_path('/bbb/ccc/ddd//?aaa?fff')['path'], '/bbb/ccc/ddd//')

    def test_dir(self):
        self.failUnlessEqual(parse_request_path('?aaa')['dir'], '')
        self.failUnlessEqual(parse_request_path('bbb?aaa')['dir'], 'bbb')
        self.failUnlessEqual(parse_request_path('/bbb?aaa')['dir'], 'bbb')
        self.failUnlessEqual(parse_request_path('/bbb/ccc?aaa')['dir'], 'bbb')
        self.failUnlessEqual(parse_request_path('/bbb/ccc/ddd//?aaa?fff')['dir'], 'bbb')

    def test_cmd(self):
        self.failUnlessEqual(parse_request_path('?aaa')['cmd'], '')
        self.failUnlessEqual(parse_request_path('bbb?aaa')['cmd'], '/bbb')
        self.failUnlessEqual(parse_request_path('/bbb?aaa')['cmd'], '/bbb')
        self.failUnlessEqual(parse_request_path('/bbb/ccc?aaa')['cmd'], '/bbb/ccc')
        self.failUnlessEqual(parse_request_path('/bbb/ccc/?aaa')['cmd'], '/bbb/ccc')
        self.failUnlessEqual(parse_request_path('/bbb/ccc//?aaa')['cmd'], '/bbb/ccc')
        self.failUnlessEqual(parse_request_path('/bbb/ccc/ddd//?aaa?fff')['cmd'], '/bbb/ccc')


if __name__ == '__main__':
    unittest.main()

