# -*- coding:utf-8 -*-

from releaser.subscriptions.events_base import BaseEvent, event

@event
class OpenReleaseTicketsEvent(BaseEvent):
    event_type = 'open_release_tickets'

    @staticmethod
    def display_subscription(sub):
        return u'Открытые тикеты в последнем релизе'

    def notification_content_for_yamb(self, recipient):
        issues = self.event_data['issues']
        issue_status_map = self.event_data['issue_status_map']

        message_lines = []
        for issue in issues:
            issue_id = issue.issue_id
            issue_status = issue_status_map[issue_id]

            message_lines.append(u'{issue} ({status}): {summary} {link}'.format(
                issue=issue_id,
                status=issue_status,
                summary=issue.summary,
                link=issue.display_url(),
                ))

        if not message_lines:
            return None

        message_lines.insert(0, u"Открытые тикеты в релизе {release}:".format(release=self.event_data['latest_release'].jira_id))

        return "\n".join(message_lines)
