# -*- encoding: utf-8 -*-
# django-admin.py process_releaseplans --settings=releaser.settings.direct --pythonpath=../

from __future__ import with_statement

import httplib2
from urllib import urlencode

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

from pprint import pprint as p
import tempfile, re, string, os, time, sys, yaml
from datetime import datetime, timedelta
from optparse import make_option
from contextlib import contextmanager
from django.utils.encoding import smart_str, smart_unicode

#import copy

from django.db.models import Q
from django.conf import settings
from releaser.yambclient.client import YambClient
from releaser.svnlog.models import SvnLog
from releaser.svnlog.tools import get_recent_releases, get_new_release_base
#from releaser.flagman.models import Flag
from releaser.metatracker.models import Issue #, IssueStatusHistory
from releaser.utils import locked_file
from releaser.rights.tools import has_right, exclusive_holder
from releaser.startrek.tools import startrek_status_key_to_str, get_startrek_robot_token
from releaser.utils import make_display_url
import warnings
with warnings.catch_warnings():
    warnings.filterwarnings("ignore", category=DeprecationWarning)
    from startrek_client import Startrek
import logging
logging.getLogger("startrek_client.collections").addHandler(logging.NullHandler())


STATUSES_NEW = ['Open', 'Need Info']

class Command(BaseCommand):
    """
    Смотрим на статусы тикетов из транковых коммитов, из релиз-кандидата и т.п.
    и рассылаем напоминания об ожидаемых действиях с этими тикетами
    """
    help = "Remind about necessary actions on tracker issues"


    @transaction.commit_on_success
    def open_issues_in_trunk(self):
        startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.USER_AGENT)

        base = get_new_release_base()
        svnlog_list = SvnLog.objects.filter(svnlogbranch__branch__path = settings.SVN_DEFAULT_BRANCH, rev__gt=base)

        problems = {}
        for s in svnlog_list:
            issues = s.issue_set.all()
            author = s.author.login
            #sys.stderr.write("rev %s %s\n" % (s.rev, author))
            for i in issues:
                #проверям только тикеты из основного проекта
                if not re.search(settings.ISSUE_KEY_REGEXP, i.issue_id):
                    continue

                issue = startrek.issues[i.issue_id]
                status_str = startrek_status_key_to_str(issue.status.key)
                #sys.stderr.write("status %s\n" % (status_code_to_str(issue.status)))
                if not status_str in STATUSES_NEW:
                    continue

                # TODO проверять какую-нибудь специальную метку, чтобы пропускать откаченные и т.п. коммиты
                commits_to_ignore = []
                comments = issue.comments
                for c in comments:
                    comment_text = c.text
                    comment_author = c.createdBy.id
                    m = re.match(ur'^ *[Мм]ониторинг.*пропуск.* +коммит.*?: *([0-9, ]*)', comment_text)
                    if not m or not len(m.groups()) > 0:
                        continue
                    if not has_right(comment_author, 'release_engineer'):
                        continue

                    commits_to_ignore += re.split('[^0-9]+', m.groups()[0])

                if str(s.rev) in commits_to_ignore:
                    continue

                if not author in problems:
                    problems[author] = []

                problems[author] += [ [ s.rev, i.issue_id, status_str ] ]

        yamb = YambClient()
        for author in problems:
            message_parts = []
            for p in problems[author]:
                message_parts += [ (u"коммит %s, тикет %s в состоянии %s" % ( p[0], make_display_url(p[1]), p[2] )) ]

            if len(message_parts) == 0:
                continue

            message_parts = [
                    (u'(Табулa) В транке проекта %s есть твои коммиты по незакрытым тикетам:\n' % (settings.PROJECT))
                    ] + message_parts
            message_parts = [u'для %s' % author ] + message_parts
            message_parts += [
                    u'',
                    u'### Что надо сделать (прямо сейчас):',
                    u' * Если тикет Internal Design -- просто закрой',
                    u' * Если тикет можно протестировать -- зарезолви и попроси тестировщиков скорее протестировать.',
                    (u' * Если тикет почему-то нельзя закрыть прямо сейчас: напиши релиз-инженеру (сейчас это %s@), что произошло. RE отключит сообщения и сделает остальное, что требуется.' % exclusive_holder('release_engineer').login ),
                    u'',
                    u'### Для RM:',
                    u'Магический комментарий: "Мониторинг, пропускаем коммиты: <здесь номера коммитов через запятую>"',
                    u'',
                    u'Пожелания, предложения? Пиши lena-san@ .',
                    ]

            msg = "\n".join(message_parts)
            to_arr = [ author, exclusive_holder('release_engineer').login, "lena-san" ]

            for login in to_arr:
                to = login
                yamb.send_message(to, msg)

            #to = author
            #yamb.send_message(to, msg)

            # TODO убрать через некоторое время
            #to = 'lena-san'
            #yamb.send_message(to, msg)

        return



    def handle(self, **options):
        with locked_file('reminder_of_issues'):
            self.open_issues_in_trunk()

        return

