# -*- encoding: utf-8 -*-

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction
from django.conf import settings

from releaser.yambclient.client import YambClient
from releaser.utils import locked_file
from releaser.startrek.tools import get_startrek_robot_token
import warnings
with warnings.catch_warnings():
    warnings.filterwarnings("ignore", category=DeprecationWarning)
    from startrek_client import Startrek
import logging
logging.getLogger("startrek_client.collections").addHandler(logging.NullHandler())


class Command(BaseCommand):
    help = u"Напоминаем о тикетах, находящихся в тестировании в каком-либо релизе"
    MAX_TICKETS_TO_SHOW = 10

    @transaction.commit_on_success
    def run(self):
        startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.USER_AGENT)
        users_tickets = {}

        tickets = startrek.issues.find('Tags: release_testing Status: !Closed')
        for ticket in tickets:
            apps = [tag[len('release_testing_'):] for tag in ticket.tags if tag.startswith('release_testing_')]
            if not apps:
                continue

            user = None
            if ticket.qaEngineer:
                user = ticket.qaEngineer.id
            elif ticket.assignee:
                user = ticket.assignee.id
            elif ticket.createdBy:
                user = ticket.createdBy.id
            else:
                continue

            if user not in users_tickets:
                users_tickets[user] = []
            users_tickets[user].append({'ticket': ticket, 'apps': apps})

        yamb = YambClient()
        for user in users_tickets:
            msg = "%s\n\n%s%s\n\n%s" % (
                u"Привет! В релизах тебя дожидаются следующие тикеты:",
                u"\n".join(u"%s: %s (%s)" % (
                    ticket['ticket'].key,
                    ticket['ticket'].summary,
                    u", ".join(ticket['apps'])
                ) for ticket in users_tickets[user][:self.MAX_TICKETS_TO_SHOW]),
                (u"" if len(users_tickets[user]) <= self.MAX_TICKETS_TO_SHOW
                 else u"показаны первые %d из %d" % (self.MAX_TICKETS_TO_SHOW, len(users_tickets[user]))),
                u"Ссылка на запрос в трекере: https://st.yandex-team.ru/filters/filter?query=Status%3A%20!closed%20Tags%3A%20release_testing%20(QA-Engineer%3A%20me()%20OR%20(QA-Engineer%3A%20!me()%20Assignee%3A%20me())%20OR%20(QA-Engineer%3A%20!me()%20Assignee%3A%20!me()%20Author%3A%20me()))%20"
            )

            yamb.send_message(user, msg)

        return


    def handle(self, **options):
        with locked_file('reminder_of_issues_v2'):
            self.run()

        return

