# -*- encoding: utf-8 -*-

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

from pprint import pprint as p
import tempfile, re, string, os, time, sys, urllib2
from optparse import make_option
from contextlib import contextmanager

#import copy

from django.db.models import Q
from django.conf import settings
from releaser.utils import locked_file

from releaser.metatracker.models import Issue
from releaser.svnlog.tools import get_recent_releases, get_new_release_base, get_svnlog_stat
from releaser.versionica.installed_versions import has_commit, check_commits
from releaser.svnlog.models import *
from releaser.versionica.models import HostGroup
import warnings
with warnings.catch_warnings():
    warnings.filterwarnings("ignore", category=DeprecationWarning)
    import startrek_client
    from startrek_client import Startrek
import logging
logging.getLogger("startrek_client.collections").addHandler(logging.NullHandler())
from releaser.startrek.tools import startrek_status_key_to_str, get_startrek_robot_token, last_releases_query, get_sign_comment
import releaser.common.apps_conf as AppsConf
import dateutil.parser
import datetime
import pytz
import time


class Command(BaseCommand):
    help = "Commenting tracker on deploy"
    debug = True
    MAX_TIME_TO_CHECK_RELEASE = 28 * 24 * 60 * 60
    TRIES_NUM = 6
    INTERVAL = 1

    def dprint(self, *args):
        if self.debug:
            print ", ".join(map(lambda x: unicode(x), args))

    @transaction.commit_on_success
    def do_all_work(self):
        apps_conf = AppsConf.get(add_perl_direct=True)
        startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.USER_AGENT)

        svnlog_table = SvnLog.objects.all().order_by('-rev')
        svndiff_table = SvnDiff.objects.all()
        head_rev = svnlog_table[0].rev
        group = None

        if settings.PROJECT != 'javadirect':
            svnlog_table = svnlog_table.filter(svnlogbranch__branch__path=settings.SVN_DEFAULT_BRANCH).order_by('rev')
            group = HostGroup.objects.get(name='production')

        tickets2commits = {}
        now = datetime.datetime.now()

        for app in apps_conf:
            try:
                recent_releases = get_recent_releases(
                    apps_conf[app]['releases_to_check_for_deploy'] + 1,
                    apps_conf[app]['id']
                )

                last_allowed_release = None
                for release in reversed(recent_releases):
                    release_issue = startrek.issues[release.jira_id]
                    if release_issue.status.key != "closed" or \
                        (now - dateutil.parser.parse(release_issue.resolvedAt).replace(tzinfo=None)).total_seconds() <= self.MAX_TIME_TO_CHECK_RELEASE:
                        last_allowed_release = release
                        break

                if not last_allowed_release:
                    continue

                start_rev = last_allowed_release.base_rev
                direct_diff_revs_set = set(r[0] for r in svndiff_table.filter(Q(path__path__startswith='/trunk/arcadia/direct/perl') | Q(path__path__startswith='/branches/direct/release/perl'), rev__range=(start_rev, head_rev + 1)).values_list('rev'))
                # автотесты Директа, не связаны с остальным java-кодом
                qa_diff_revs_set = set(r[0] for r in svndiff_table.filter(
                    Q(path__path__startswith='/trunk/arcadia/direct/qa')|Q(path__path__startswith='/trunk/arcadia/direct/infra'),
                    rev__range=(start_rev, head_rev + 1)
                ).values_list('rev'))

                if app == 'direct':
                    revs = sorted(list(direct_diff_revs_set))
                else:
                    svnlog = svnlog_table.filter(Q(rev__range=(start_rev, head_rev + 1))).order_by('rev')
                    revs = [s.rev for s in svnlog if s.rev not in direct_diff_revs_set and s.rev not in qa_diff_revs_set]

                commit_statuses = check_commits(group, revs, None, app)

                for commit in commit_statuses:
                    if commit_statuses[commit]:
                        issues = Issue.objects.filter(commits__in=[commit])
                        for issue_db in issues:
                            if issue_db.issue_id not in tickets2commits:
                                tickets2commits[issue_db.issue_id] = {}

                            if app not in tickets2commits[issue_db.issue_id]:
                                tickets2commits[issue_db.issue_id][app] = []

                            tickets2commits[issue_db.issue_id][app].append('r' + str(commit))

            except Exception as e:
                print "ERROR: %s %s %s" % (app, type(e), e)

        for ticket in tickets2commits:
            try:
                issue = startrek.issues[ticket]
            except startrek_client.exceptions.NotFound:
                continue

            for app in tickets2commits[ticket]:
                if apps_conf[app]['tracker-deployed-tag'] in issue.tags:
                    continue

                for i in xrange(self.TRIES_NUM):
                    try:
                        comment = u"Автоматический мониторинг: выехало в продакшен проекта %s с коммитом %s" % (
                            app, ', '.join(tickets2commits[ticket][app])
                        )
                        startrek.issues[ticket].comments.create(
                            text=comment + u"\n" + get_sign_comment(os.path.basename(__file__))
                        )
                        break
                    except Exception, e:
                        if i + 1 != self.TRIES_NUM:
                            time.sleep(self.INTERVAL)

            # временное решение из-за отставания реплики стартрека
            # надо бы им везде ретраи прикрутить, а не нам вручную их при каждом обращении расставлять
            for i in xrange(self.TRIES_NUM):
                try:
                    startrek.issues[ticket].update(
                        tags=startrek.issues[ticket].tags + [
                            apps_conf[app]['tracker-deployed-tag'] for app in tickets2commits[ticket]
                        ]
                    )
                    break
                except:
                    if i + 1 != self.TRIES_NUM:
                        time.sleep(self.INTERVAL)

        return


    def handle(self, **options):
        with locked_file('update_tracker_on_deploy'):
            self.do_all_work()
        return

