# -*- encoding: utf-8 -*-

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

from pprint import pprint as p
import tempfile, re, string, os, time, sys, urllib2
from datetime import datetime
from optparse import make_option
from contextlib import contextmanager
import yaml
import subprocess

from django.db.models import Q
from django.conf import settings
from releaser.utils import locked_file
import tempfile
import shutil

from releaser.conductor_client.client import *
from releaser.versionica.models import *
from releaser.metatracker.models import Issue
from releaser.svnlog.tools import get_recent_releases, get_new_release_base, get_svnlog_stat
from releaser.versionica.installed_versions import has_commit, check_commits
from releaser.svnlog.models import *
import warnings
with warnings.catch_warnings():
    warnings.filterwarnings("ignore", category=DeprecationWarning)
    import startrek_client
    from startrek_client import Startrek
import logging
logging.getLogger("startrek_client.collections").addHandler(logging.NullHandler())
from releaser.startrek.tools import startrek_status_key_to_str, get_startrek_robot_token, last_releases_query, get_sign_comment
import releaser.common.apps_conf as AppsConf


class Command(BaseCommand):
    help = "Commenting tracker on deploy dna"

    dna_config_name = "dna"


    def get_tickets_from_log(self, version_from, version_to):
        tempdir = tempfile.mkdtemp(prefix=os.path.basename(__file__), dir='/tmp/temp-ttl/ttl_1d')
        try:
            subprocess.call(['git', 'clone', '-q', 'https://github.yandex-team.ru/direct/dna', tempdir])
            os.chdir(tempdir)
            log = subprocess.check_output(['git', 'log', '--oneline', "v%s..v%s" % (version_from, version_to)])

            return re.findall(ur"^(.+)\s+(DIRECT-[0-9]+)", log, re.I | re.U | re.M)

        finally:
            shutil.rmtree(tempdir)


    @transaction.commit_on_success
    def do_all_work(self):
        startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.USER_AGENT)

        apps_conf = AppsConf.get()
        dna_conf = apps_conf[self.dna_config_name]

        hosts = ConductorRestClient().groups2hosts(dna_conf['conductor_groups'])

        versions = HostPropertyLog.objects.all().select_related('host__name', 'property__name').filter(
                    group__name='packages',
                    property__name=dna_conf['package'],
                    host__name__in=hosts,
                    ).order_by('-logtime').values('value')

        versions_list = []
        for version in versions:
            if not versions_list or versions_list[-1] != version['value']:
                versions_list.append(version['value'])
                if len(versions_list) > 4:
                    break

        tickets = self.get_tickets_from_log(versions_list[-1], versions_list[0])

        tickets2commits = {}

        for ticket in tickets:
            if ticket[1] not in tickets2commits:
                tickets2commits[ticket[1]] = []

            tickets2commits[ticket[1]].append(ticket[0])

        for ticket in tickets2commits:
            try:
                issue = startrek.issues[ticket]
            except startrek_client.exceptions.NotFound:
                continue

            if dna_conf['tracker-deployed-tag'] in issue.tags:
                continue

            try:
                comment = u"Автоматический мониторинг: выехало в продакшен проекта %s с коммитом %s" % (self.dna_config_name, ', '.join(tickets2commits[ticket]))

                startrek.issues[issue.key].comments.create(text=comment + u"\n" + get_sign_comment(os.path.basename(__file__)))
                startrek.issues[issue.key].update(tags=startrek.issues[issue.key].tags + [dna_conf['tracker-deployed-tag']])

                #need_deployed_flag = True
                #for app_i in apps_conf:
                #    if 'tracker-deployed-tag' in apps_conf[app_i] and apps_conf[app_i]['tracker-deployed-tag'] != dna_conf['tracker-deployed-tag'] and apps_conf[app_i]['tracker-deployed-tag'] not in startrek.issues[issue.key].tags:
                #        need_deployed_flag = False
                #        break

                #if need_deployed_flag:
                #    startrek.issues[issue.key].update(deployed = u'Да')
            except Exception, e:
                pass

        return


    def handle(self, **options):
        with locked_file('update_tracker_on_deploy_dna'):
            self.do_all_work()
        return

