# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'IssueStatusHistory'
        db.create_table('metatracker_issuestatushistory', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('issue', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['metatracker.Issue'])),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')(db_index=True)),
            ('prev_run_time', self.gf('django.db.models.fields.DateTimeField')()),
            ('new_status', self.gf('django.db.models.fields.CharField')(max_length=60)),
        ))
        db.send_create_signal('metatracker', ['IssueStatusHistory'])

    def backwards(self, orm):

        # Deleting model 'IssueStatusHistory'
        db.delete_table('metatracker_issuestatushistory')

    models = {
        'metatracker.issue': {
            'Meta': {'object_name': 'Issue'},
            'assignee': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'commits': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['svnlog.SvnLog']", 'db_column': "'rev'", 'symmetrical': 'False'}),
            'issue_id': ('django.db.models.fields.CharField', [], {'max_length': '20', 'primary_key': 'True'}),
            'releases': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'problem_of_release'", 'symmetrical': 'False', 'through': "orm['metatracker.Problem']", 'to': "orm['svnrelease.SvnRelease']"}),
            'summary': ('django.db.models.fields.CharField', [], {'max_length': '200'})
        },
        'metatracker.issuestatushistory': {
            'Meta': {'object_name': 'IssueStatusHistory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'issue': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['metatracker.Issue']"}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'new_status': ('django.db.models.fields.CharField', [], {'max_length': '60'}),
            'prev_run_time': ('django.db.models.fields.DateTimeField', [], {})
        },
        'metatracker.problem': {
            'Meta': {'unique_together': "(('release', 'issue', 'origin', 'context_details'),)", 'object_name': 'Problem'},
            'context_details': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'issue': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'issues'", 'to': "orm['metatracker.Issue']"}),
            'origin': ('django.db.models.fields.IntegerField', [], {}),
            'release': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'releases'", 'to': "orm['svnrelease.SvnRelease']"}),
            'relevance': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'significance': ('django.db.models.fields.IntegerField', [], {'default': '0'})
        },
        'svnlog.svnauthor': {
            'Meta': {'object_name': 'SvnAuthor'},
            'author_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        },
        'svnlog.svnlog': {
            'Meta': {'object_name': 'SvnLog'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnAuthor']"}),
            'hotfix': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'message': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'rev': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'}),
            'revtime': ('django.db.models.fields.DateTimeField', [], {})
        },
        'svnrelease.svnrelease': {
            'Meta': {'object_name': 'SvnRelease'},
            'base_rev': ('django.db.models.fields.IntegerField', [], {}),
            'create_time': ('django.db.models.fields.DateTimeField', [], {}),
            'deploy': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'deploy_notes': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'jira_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'jira_status': ('django.db.models.fields.CharField', [], {'max_length': '40'}),
            'release_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tip_rev': ('django.db.models.fields.IntegerField', [], {}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '256'})
        }
    }

    complete_apps = ['metatracker']
