# -*- coding:utf-8 -*-

from django.conf import settings

from startrek_client import Startrek

import releaser.metatracker.models as metatracker
from releaser.metatracker.events import OpenReleaseTicketsEvent
from releaser.startrek.tools import startrek_status_key_to_str, get_startrek_robot_token
from releaser.scheduler.tasks_base import task
from releaser.svnlog.tools import get_recent_releases

@task(schedule='17 10,13,18 * * 1,2,3,4,5')
def watch_open_release_tickets():
    latest_release = get_recent_releases(1)[0]

    if latest_release.jira_status not in [ 'Open', 'Ready for test', 'Testing' ]:
        return

    problems = metatracker.Problem.objects.filter(release=latest_release).select_related('issue')
    issue_ids = [ problem.issue.issue_id for problem in problems ]

    # TODO: делить массив тикетов на пачки, как в releaser/tracker_proxy/views.py
    issue_status_map = {}
    startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.STARTREK_CLIENT_USER_AGENT)
    startrek_issue_info = startrek.issues.find('Key: ' + ','.join(issue_ids))
    for issue in startrek_issue_info:
        issue_status_map[issue.key] = startrek_status_key_to_str(issue.status.key)

    relevant_issues = [ problem.issue for problem in problems if issue_status_map[problem.issue.issue_id] not in ['Beta-tested', 'Closed']]
    if not relevant_issues:
        return

    event_data = {
        'issues': relevant_issues,
        'issue_status_map': issue_status_map,
        'latest_release': latest_release,
        }

    OpenReleaseTicketsEvent(event_data).send_notifications()

