# -* encoding: utf-8 -*-
import math, sys, os, random, time, string, re

from datetime import datetime, timedelta

from django.utils.dateparse import parse_datetime

from django.conf import settings
from startrek_client import *
from releaser.startrek.tools import startrek_status_key_to_str, get_startrek_robot_token

# история изменения статусов для указанных тикетов
def status_changes(issue_ids):
    result = {}
    startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.STARTREK_CLIENT_USER_AGENT)
    for issue_id in issue_ids:
        result[issue_id] = []
        changelog = result[issue_id];
        try:
            issue = startrek.issues[issue_id]
            raw_changelog = issue.changelog.get_all(field=('status'))
            changelog += [{
                "time_str": issue.createdAt,
                "toString": "Open"
                }]

            for entry in raw_changelog:
                status_change = next(field for field in entry['fields'] if field['field'].id == 'status')
                changelog += [{
                    "time_str": entry.updatedAt,
                    "toString": startrek_status_key_to_str(status_change['to'].key)
                }]
        except:
            # если тикет не нашелся или другая проблема
            # -- показываем его вечнооткрытым
            changelog += [{
                "time_str": "1970-01-01T00:00:00.000+0400",
                "toString": "Open"
                }]

        for ch in changelog:
            ch['timestamp'] = int(time.mktime(parse_datetime( ch['time_str'] ).timetuple()))


    return result

# история изменения псевдо-статусов для указанных тикетов
# по полю java_testing_field
# FORGIVEME это слегка отредактированная копия status_changes, хорошо бы когда-нибудь объединить
def pseudo_status_changes(issue_ids, java_testing_field, affected_app):
    pseudo_statuses_translation = {
            u"Не требуется проверка": "psJSkipTesting",
            u"Проверка сделана": "psJTestingDone",
            u"Требуется проверка": "psJNeedsTesting",
            }
    result = {}
    startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.STARTREK_CLIENT_USER_AGENT)
    for issue_id in issue_ids:
        result[issue_id] = []
        changelog = result[issue_id]
        try:
            issue = startrek.issues[issue_id]
            raw_changelog = issue.changelog.get_all(fields=java_testing_field + ",affectedApps,testedApps")
            changelog += [{
                "time_str": issue.createdAt,
                "toString": "psJNew"
                }]

            affected = False
            tested = False
            for entry in raw_changelog:
                for field in entry['fields']:
                    if field['field'].id == java_testing_field:
                        changelog += [{
                            "time_str": entry.updatedAt,
                            "toString": pseudo_statuses_translation.get(field['to'], 'psJUnknown')
                        }]
                    elif field['field'].id == 'affectedApps' and field['to'] and affected_app in field['to'] and not affected:
                        changelog += [{
                            "time_str": entry.updatedAt,
                            "toString": 'psJNeedsTesting'
                        }]
                        affected = True
                    elif field['field'].id == 'testedApps' and field['to'] and  affected_app in field['to'] and not tested:
                        changelog += [{
                            "time_str": entry.updatedAt,
                            "toString": 'psJTestingDone'
                        }]
                        tested = True

            ### Если статус в тикете никогда не менялся -- проставляем в качестве начального
            # текущий статус
            # Если поле проставили прямо при создании, то у тикета может быть
            # TestingDone, и при этом в истории нет редактирования статуса
            if len(changelog) == 1:
                if affected_app in issue['testedApps']:
                    changelog[0]['toString'] = 'psJTestingDone'
                elif affected_app in issue['affectedApps']:
                    changelog[0]['toString'] = 'psJNeedsTesting'
                elif issue['affectedApps']:
                    changelog[0]['toString'] = 'psJSkipTesting'
                elif java_testing_field and issue[java_testing_field] in pseudo_statuses_translation:
                    changelog[0]['toString'] = pseudo_statuses_translation[issue[java_testing_field]]
        except:
            raise
            # если тикет не нашелся или другая проблема
            # -- показываем его вечнооткрытым
            changelog += [{
                "time_str": "1970-01-01T00:00:00.000+0400",
                "toString": "psJNew"
                }]

        for ch in changelog:
            ch['timestamp'] = int(time.mktime(parse_datetime( ch['time_str'] ).timetuple()))


    return result

