# -*- encoding: utf-8 -*-

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

from pprint import pprint as p
import pysvn, tempfile, re, string, os, time, sys, errno
from datetime import datetime
from optparse import make_option
from contextlib import contextmanager

from django.conf import settings
from releaser.svnlog.models import SvnLog, SvnAuthor, SvnBranch, SvnLogBranch, SvnLogHotfix, SvnPath, SvnDiff

from releaser.migrations.models import Migration
from releaser.migrations.views import *

from releaser.utils import hash, decode_str

@contextmanager
def locked_file(filename):
    full_filename = "%s/%s" % (settings.LOCKS_PATH, filename)
    f = open(full_filename, 'wb')
    locks.lock(f, locks.LOCK_EX|locks.LOCK_NB)
    try:
        yield
    finally:
        locks.unlock(f)
        f.close()
        os.unlink(full_filename)



class Command(BaseCommand):
    help = "Fetch svn log entries from svn to database"
    debug = True

    option_list = BaseCommand.option_list + (
        make_option('--start', action='store', dest='start', type='int',
            default=-1, help='start revision'),
        make_option('--end', action='store', dest='end', type='int',
            default=-1, help='end revision'),
    )


    def full_svn_url(self, path):
        return settings.RELEASER_SVN + path

    #@transaction.commit_manually
    def handle(self, **options):
        with locked_file('migrations_fetch_migrations'):
            svn = pysvn.Client()
            svn.exception_style = 1
            if options["start"] == -1:
                options["start"] = Migration.objects.order_by('-rev')[0].rev
            if options["end"] == -1:
                options["end"] = SvnLog.objects.order_by('-rev')[0].rev

            revisions_to_ignore = set()
            if settings.PROJECT == 'direct':
                # Для ревизии 57480 в базу почему-то сохранился неправильный дифф. В "настоящем" диффе миграций нет, пропускаем.
                revisions_to_ignore.add(57480)

            #sys.stderr.write("%s - %s\n" % ( options["start"], options["end"] ))
            for rev in range(options["start"], options["end"]):
                #sys.stderr.write("rev %s\n" % (rev))
                if rev in revisions_to_ignore:
                    continue
                changed_files = SvnDiff.objects.filter(rev=rev)
                migrations = [ ]
                for f in changed_files:
                    if f.action == "D" and re.match(r'(/trunk|/branches/[^/]+)(/deploy/|/?$)', f.path.path):
                        Migration.objects.filter(url__startswith=self.full_svn_url(f.path.path)).delete()
                        continue

                    m = re.match('(/trunk|/branches/[^/]+)/deploy/([^/]+)$', f.path.path,)
                    if not  m:
                        continue

                    source = m.group(1)
                    filename = m.group(2)

                    if re.match(r'.*\.data$', filename):
                        continue

                    url = self.full_svn_url(f.path.path)
                    py_rev=pysvn.Revision( pysvn.opt_revision_kind.number, rev )

                    # пробуем получить текст файла
                    # ошибку 195007 пропускаем -- это '<url> refers to a directory'
                    # другой вариант -- для каждого url запрашивать его тип, но это замедляет выполнение вдвое
                    migration_text = ''
                    try:
                        migration_text = svn.cat(
                                url,
                                revision=py_rev,
                                peg_revision=py_rev,
                                )
                    except pysvn.ClientError, e:
                        if e.args[1][0][1] == 195007:
                            continue
                        else:
                            raise

                    migration_text = decode_str(migration_text)

                    task_count = 1
                    try:
                        migrator = 'migrator'
                        p = Popen([migrator, '--task-count'], stdout=PIPE, stdin=PIPE, stderr=STDOUT)

                        task_count = p.communicate(input=migration_text)[0]
                    except:
                        pass

                    migr = {
                            'rev': rev,
                            'source': source,
                            'filename': filename,
                            'text': migration_text,
                            'filename': filename,
                            'url': url,
                            'task_count': task_count,
                            'file_hash': hash(migration_text.encode('utf-8')),
                            }

                    migrations.append(migr)

                todo = filter_tasks(migrations)
                update_db(todo)

                #transaction.commit()

            return

        transaction.rollback()

