# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'MigrationText'
        db.create_table('migrations_migrationtext', (
            ('migration_text_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('filename', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('file_hash', self.gf('django.db.models.fields.CharField')(max_length=64)),
            ('text', self.gf('django.db.models.fields.TextField')(max_length=33554432, null=True)),
        ))
        db.send_create_signal('migrations', ['MigrationText'])

        # Adding unique constraint on 'MigrationText', fields ['filename', 'file_hash']
        db.create_unique('migrations_migrationtext', ['filename', 'file_hash'])

        # Adding model 'Migration'
        db.create_table('migrations_migration', (
            ('migration_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('filename', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('rev', self.gf('django.db.models.fields.IntegerField')()),
            ('time', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now)),
            ('file_hash', self.gf('django.db.models.fields.CharField')(max_length=64)),
            ('task_count', self.gf('django.db.models.fields.IntegerField')()),
            ('source', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnBranch'])),
            ('url', self.gf('django.db.models.fields.CharField')(max_length=1000)),
            ('text', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['migrations.MigrationText'])),
        ))
        db.send_create_signal('migrations', ['Migration'])

        # Adding unique constraint on 'Migration', fields ['filename', 'source']
        db.create_unique('migrations_migration', ['filename', 'source_id'])

    def backwards(self, orm):

        # Removing unique constraint on 'Migration', fields ['filename', 'source']
        db.delete_unique('migrations_migration', ['filename', 'source_id'])

        # Removing unique constraint on 'MigrationText', fields ['filename', 'file_hash']
        db.delete_unique('migrations_migrationtext', ['filename', 'file_hash'])

        # Deleting model 'MigrationText'
        db.delete_table('migrations_migrationtext')

        # Deleting model 'Migration'
        db.delete_table('migrations_migration')

    models = {
        'migrations.migration': {
            'Meta': {'unique_together': "(('filename', 'source'),)", 'object_name': 'Migration'},
            'file_hash': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'filename': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'migration_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'rev': ('django.db.models.fields.IntegerField', [], {}),
            'source': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnBranch']"}),
            'task_count': ('django.db.models.fields.IntegerField', [], {}),
            'text': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['migrations.MigrationText']"}),
            'time': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '1000'})
        },
        'migrations.migrationtext': {
            'Meta': {'unique_together': "(('filename', 'file_hash'),)", 'object_name': 'MigrationText'},
            'file_hash': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'filename': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'migration_text_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'text': ('django.db.models.fields.TextField', [], {'max_length': '33554432', 'null': 'True'})
        },
        'svnlog.svnbranch': {
            'Meta': {'object_name': 'SvnBranch'},
            'branch_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'path': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        }
    }

    complete_apps = ['migrations']
