# -*- coding:utf-8 -*-
from django.db import models
from datetime import datetime

from releaser.svnlog.models import *

class MigrationText(models.Model):
    migration_text_id = models.AutoField(primary_key=True,)
    filename = models.CharField(max_length=128)
    file_hash = models.CharField(max_length=64)
    text = models.TextField(max_length=32*1024*1024, null=True)
    class Meta:
        unique_together = (("filename", "file_hash"),)

class Migration(models.Model):
    migration_id = models.AutoField(primary_key=True,)
    filename = models.CharField(max_length=128)
    task_count = models.IntegerField()
    rev = models.IntegerField()
    time = models.DateTimeField(default=datetime.now)
    file_hash = models.CharField(max_length=64)
    task_count = models.IntegerField()
    source = models.ForeignKey(SvnBranch)
    url = models.CharField(max_length=1000, )
    text = models.ForeignKey(MigrationText)
    class Meta:
        unique_together = (("filename", "source"),)

