# -* encoding: utf-8 -*-
import json
from django.http import HttpResponse, Http404
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.db.models import Q
import re, math, sys, os, random, time, datetime
from socket import gethostbyaddr

from django.conf import settings
from releaser.migrations.models import *

def update(r):
    tasks = form2tasks(r.REQUEST)
    #sys.stderr.write("tasks %s\n" % (tasks))
    todo = filter_tasks(tasks)
    update_db(todo)

    return HttpResponse('OK', mimetype="application/javascript")


def list(r):
    return HttpResponse('OK', mimetype="application/javascript")


def form2tasks(form):
    tasks = []
    for k in form:
        if not re.match("migration_\d+", k):
            continue
        t = json.loads(form[k])
        tasks.append(t)

    return tasks


def filter_tasks(tasks):
    todo = {
        'delete': [],
        'insert': [],
        }

    filenames = [ t['filename'] for t in tasks ]
    old = Migration.objects.filter(filename__in=filenames)

    for t in tasks:
        if len(old.filter(filename=t['filename']))==0:
            # нет записей с таким же filename -- просто записываем
            # OK
            todo['insert'].append(t)
        elif len(old.filter(filename=t['filename'], source__path=t['source'], file_hash=t['file_hash'])) > 0:
            # есть запись с таким же filename, source, md5 (hash)
            # -- пропускаем
            # OK -- два раза одно и то же отправить
            pass
        elif len(old.filter(filename=t['filename'], file_hash=t['file_hash'], source__path='/trunk')) > 0:
            # есть транковая миграция с таким же filename, hash
            # -- пропускаем, это мерж из транка приехал
            # OK -- мерж из транка в бранч после обработки транка
            pass
        elif len(old.filter(filename=t['filename'], source__path=t['source']).filter(~Q(file_hash=t['file_hash']))) > 0:
            if len(old.filter(filename=t['filename'], source__path=t['source'], rev__gt=t['rev']).filter(~Q(file_hash=t['file_hash']))) == 0:
                # есть старая версия этой же миграции --
                # удаляем старую, записываем новую
                # OK - обработана старая версия миграции, и потом она же еще редактируется
                todo['delete'].append({'filename': t['filename'], 'source__path': t['source']})
                todo['insert'].append(t)
            else:
                # ?? - обработана новая редакция миграции, и потом приходит ее старцй вариант
                # не бывает: svn cat делается от последней ревизии, т.е. всегда отправляется самая новая версия
                pass
        else:
            # OK - обработан один бранч, и потом другой, а транк -- нет
            # OK -- то же самое, но миграция поменялась
            todo['insert'].append(t)

    #sys.stderr.write("todo %s\n" % (todo))
    return todo



def update_db(todo):
    for cond in todo['delete']:
        for t in Migration.objects.filter(**cond):
            t.delete()

    for t in todo['insert']:
        #sys.stderr.write("path: %s\n" % (t['source']))
        t['source'] = SvnBranch.objects.get(path=t['source'])
        t['text'], _ = MigrationText.objects.get_or_create(
                filename=t['filename'],
                file_hash=t['file_hash'],
                defaults={
                    'filename': t['filename'],
                    'file_hash': t['file_hash'],
                    'text': t['text']
                    }
                )
        migr = Migration(**t)
        migr.save()

    return

