# -*- encoding: utf-8 -*-
# django-admin.py process_releaseplans --settings=releaser.settings.direct --pythonpath=../

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction
from django.conf import settings

from releaser.ptera.models import NotifyOnDeploy
from releaser.metatracker.models import Issue
from releaser.yambclient.client import YambClient
from releaser.utils import locked_file
from releaser.versionica.installed_versions import check_commits


class Command(BaseCommand):
    help = "Sending notifications on commits deploy"
    debug = True

    def dprint(self, *args):
        if self.debug:
            print ", ".join(map(lambda x: unicode(x), args))

    @transaction.commit_on_success
    def tasks2commits(self):
        for n in NotifyOnDeploy.objects.all():
            if n.commit > 0:
                continue
            try:
                issue = Issue.objects.get(issue_id=n.jira_issue)
            except Issue.DoesNotExist:
                continue
            commits = issue.commits.all().filter(svnlogbranch__branch__path='/trunk')
            if len(commits) > 0:
                n.commit = sorted([c.rev for c in commits])[0]
                n.save()
        return

    @transaction.commit_on_success
    def notify(self):
        data = [n for n in NotifyOnDeploy.objects.all() if n.commit > 0]
        commits_by_dest = {}
        for n in data:
            if n.destination_group not in commits_by_dest:
                commits_by_dest[n.destination_group] = []
            commits_by_dest[n.destination_group].append(n.commit)

        commits_statuses = {}
        for dest in commits_by_dest:
            commits_statuses[dest] = check_commits(dest, list(set(commits_by_dest[dest])))

        notifications = {}
        for n in data:
            if not commits_statuses[n.destination_group][n.commit]:
                continue
            recipient = n.recipient.login
            dest = n.destination_group.name
            if not recipient in notifications:
                notifications[recipient] = {}
            if not dest in notifications[recipient]:
                notifications[recipient][dest] = []
            notifications[recipient][dest] += [{
                    'commit': n.commit,
                    'comment': n.comment,
                    }]
            n.delete()

        yamb = YambClient()
        for (user, user_notifications) in notifications.iteritems():
            message_parts = []
            for (dest, nlist) in user_notifications.iteritems():
                message_parts += [(u'\n### %s / %s' % (settings.PROJECT, dest))]
                for n in nlist:
                    message_parts += [(u'r%s (%s)' % (n['commit'], n['comment']))]
            if len(message_parts) == 0:
                continue
            message_parts = [u'(Табулa) Выехали коммиты:'] + message_parts
            message_parts = [u'для %s' % user ] + message_parts
            msg = "\n".join(message_parts)
            to = user
            yamb.send_message(to, msg)

        return

    def handle(self, **options):
        with locked_file('deploy_notification'):
            self.tasks2commits()
            self.notify()
        return

