# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'Environment'
        db.create_table('ptera_environment', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=100)),
            ('alias', self.gf('django.db.models.fields.CharField')(unique=True, max_length=100)),
            ('main_host', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.Host'])),
        ))
        db.send_create_signal('ptera', ['Environment'])

        # Adding model 'NotifyOnDeploy'
        db.create_table('ptera_notifyondeploy', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('reqid', self.gf('django.db.models.fields.IntegerField')()),
            ('commit', self.gf('django.db.models.fields.IntegerField')(default=-1)),
            ('planned_task', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['releaseplanning.TaskToRelease'], null=True, blank=True)),
            ('recipient', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('env', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['ptera.Environment'])),
            ('comment', self.gf('django.db.models.fields.CharField')(max_length=500)),
        ))
        db.send_create_signal('ptera', ['NotifyOnDeploy'])

        # Adding unique constraint on 'NotifyOnDeploy', fields ['commit', 'recipient', 'planned_task']
        db.create_unique('ptera_notifyondeploy', ['commit', 'recipient_id', 'planned_task_id'])

    def backwards(self, orm):

        # Removing unique constraint on 'NotifyOnDeploy', fields ['commit', 'recipient', 'planned_task']
        db.delete_unique('ptera_notifyondeploy', ['commit', 'recipient_id', 'planned_task_id'])

        # Deleting model 'Environment'
        db.delete_table('ptera_environment')

        # Deleting model 'NotifyOnDeploy'
        db.delete_table('ptera_notifyondeploy')

    models = {
        'ptera.environment': {
            'Meta': {'object_name': 'Environment'},
            'alias': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100'})
        },
        'ptera.notifyondeploy': {
            'Meta': {'unique_together': "(('commit', 'recipient', 'planned_task'),)", 'object_name': 'NotifyOnDeploy'},
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'commit': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'env': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ptera.Environment']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'planned_task': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['releaseplanning.TaskToRelease']", 'null': 'True', 'blank': 'True'}),
            'recipient': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'reqid': ('django.db.models.fields.IntegerField', [], {})
        },
        'releaseplanning.membership': {
            'Meta': {'object_name': 'Membership'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'role': ('django.db.models.fields.IntegerField', [], {}),
            'task': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['releaseplanning.TaskToRelease']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"})
        },
        'releaseplanning.tasktorelease': {
            'Meta': {'unique_together': "(('jira_issue', 'week'),)", 'object_name': 'TaskToRelease'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'comment': ('django.db.models.fields.TextField', [], {}),
            'commit': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'jira_issue': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'}),
            'members': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'task_to_release'", 'symmetrical': 'False', 'through': "orm['releaseplanning.Membership']", 'to': "orm['users.User']"}),
            'niceness': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'plausibility': ('django.db.models.fields.DecimalField', [], {'default': '0', 'max_digits': '3', 'decimal_places': '2'}),
            'review': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'status': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'type': ('django.db.models.fields.IntegerField', [], {'default': '5'}),
            'week': ('django.db.models.fields.IntegerField', [], {'default': '10000', 'db_index': 'True'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['ptera']
