# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Changing field 'NotifyOnDeploy.reqid'
        db.alter_column('ptera_notifyondeploy', 'reqid', self.gf('django.db.models.fields.BigIntegerField')())

    def backwards(self, orm):

        # Changing field 'NotifyOnDeploy.reqid'
        db.alter_column('ptera_notifyondeploy', 'reqid', self.gf('django.db.models.fields.IntegerField')())

    models = {
        'metatracker.issue': {
            'Meta': {'object_name': 'Issue'},
            'assignee': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'commits': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['svnlog.SvnLog']", 'db_column': "'rev'", 'symmetrical': 'False'}),
            'issue_id': ('django.db.models.fields.CharField', [], {'max_length': '20', 'primary_key': 'True'}),
            'releases': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'problem_of_release'", 'symmetrical': 'False', 'through': "orm['metatracker.Problem']", 'to': "orm['svnrelease.SvnRelease']"}),
            'summary': ('django.db.models.fields.CharField', [], {'max_length': '200'})
        },
        'metatracker.problem': {
            'Meta': {'unique_together': "(('release', 'issue', 'origin', 'context_details'),)", 'object_name': 'Problem'},
            'context_details': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'issue': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'issues'", 'to': "orm['metatracker.Issue']"}),
            'origin': ('django.db.models.fields.IntegerField', [], {}),
            'release': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'releases'", 'to': "orm['svnrelease.SvnRelease']"}),
            'relevance': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'significance': ('django.db.models.fields.IntegerField', [], {'default': '0'})
        },
        'ptera.notifyondeploy': {
            'Meta': {'unique_together': "(('commit', 'recipient', 'task'),)", 'object_name': 'NotifyOnDeploy'},
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'commit': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'destination_group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.HostGroup']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'recipient': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'task': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['metatracker.Issue']", 'null': 'True', 'blank': 'True'})
        },
        'svnlog.svnauthor': {
            'Meta': {'object_name': 'SvnAuthor'},
            'author_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        },
        'svnlog.svnlog': {
            'Meta': {'object_name': 'SvnLog'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnAuthor']"}),
            'hotfix': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'message': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'rev': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'}),
            'revtime': ('django.db.models.fields.DateTimeField', [], {})
        },
        'svnrelease.svnrelease': {
            'Meta': {'object_name': 'SvnRelease'},
            'base_rev': ('django.db.models.fields.IntegerField', [], {}),
            'create_time': ('django.db.models.fields.DateTimeField', [], {}),
            'deploy': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'deploy_notes': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'jira_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'jira_status': ('django.db.models.fields.CharField', [], {'max_length': '40'}),
            'release_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tip_rev': ('django.db.models.fields.IntegerField', [], {}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '256'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostgroup': {
            'Meta': {'object_name': 'HostGroup'},
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']", 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['ptera']
