# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Removing unique constraint on 'NotifyOnDeploy', fields ['commit', 'task', 'recipient']
        db.delete_unique('ptera_notifyondeploy', ['commit', 'task_id', 'recipient_id'])

        # Deleting field 'NotifyOnDeploy.task'
        db.delete_column('ptera_notifyondeploy', 'task_id')

        # Adding field 'NotifyOnDeploy.jira_issue'
        db.add_column('ptera_notifyondeploy', 'jira_issue', self.gf('django.db.models.fields.CharField')(default='', max_length=50, db_index=True), keep_default=False)

        # Adding unique constraint on 'NotifyOnDeploy', fields ['commit', 'recipient', 'jira_issue']
        db.create_unique('ptera_notifyondeploy', ['commit', 'recipient_id', 'jira_issue'])

    def backwards(self, orm):

        # Removing unique constraint on 'NotifyOnDeploy', fields ['commit', 'recipient', 'jira_issue']
        db.delete_unique('ptera_notifyondeploy', ['commit', 'recipient_id', 'jira_issue'])

        # Adding field 'NotifyOnDeploy.task'
        db.add_column('ptera_notifyondeploy', 'task', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['metatracker.Issue'], null=True, blank=True), keep_default=False)

        # Deleting field 'NotifyOnDeploy.jira_issue'
        db.delete_column('ptera_notifyondeploy', 'jira_issue')

        # Adding unique constraint on 'NotifyOnDeploy', fields ['commit', 'task', 'recipient']
        db.create_unique('ptera_notifyondeploy', ['commit', 'task_id', 'recipient_id'])

    models = {
        'ptera.notifyondeploy': {
            'Meta': {'unique_together': "(('commit', 'recipient', 'jira_issue'),)", 'object_name': 'NotifyOnDeploy'},
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'commit': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'destination_group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.HostGroup']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'jira_issue': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'recipient': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostgroup': {
            'Meta': {'object_name': 'HostGroup'},
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']", 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['ptera']
