# -*- coding:utf-8 -*-
from django.db import models
from datetime import datetime
from releaser.users.models import *
from releaser.versionica.models import HostProperty, Host, Property
from releaser.versionica.tools import parse_version
from releaser.releaseplanning.models import TaskToRelease
from releaser.svnlog.models import SvnLog, SvnLogHotfix
from releaser.metatracker.models import Issue
from releaser.versionica.models import HostGroup

from django.conf import settings


class NotifyOnDeploy(models.Model):
    reqid = models.BigIntegerField()
    commit = models.IntegerField(default=-1)
    app_id = models.IntegerField(default=-1)
    jira_issue = models.CharField(max_length=50, db_index=True, default='')
    recipient = models.ForeignKey(User)
    destination_group = models.ForeignKey(HostGroup)
    comment = models.CharField(max_length=500)

    class Meta:
        unique_together = (("commit", "recipient", "jira_issue", "destination_group"),)
    def __unicode__(self):
        return "%s@%s to %s" % (self.commit, self.destination_group, self.recipient)
