# -* encoding: utf-8 -*-
from django.db.models import Q
from django.utils.encoding import smart_str, smart_unicode
import math, sys, re
from collections import defaultdict


from django.conf import settings
from releaser.ptera.models import *
from releaser.releaseplanning.models import *
from releaser.utils import generate_reqid
from releaser.metatracker.models import Issue
from releaser.releaseplanning.models import TaskToRelease
from releaser.svnlog.models import SvnLog


def default_comment(**kwargs):
    if 'issue' in kwargs:
        title = ''
        try:
            task = TaskToRelease.objects.filter(jira_issue=kwargs['issue'])[0]
            title = task.title
        except TaskToRelease.DoesNotExist:
            try:
                issue = Issue.objects.get(issue_id=kwargs['issue'])
                summary = issue.summary
                if summary == '' or summary == 'fake':
                    raise Issue.DoesNotExist
                title = summary
            except Issue.DoesNotExist:
                pass
        if len(title) > 0:
            return "%s: %s" % (kwargs['issue'], title)
        else:
            return kwargs['issue']
    elif 'commit' in kwargs:
        comment = SvnLog.objects.get(rev=kwargs['commit']).message
        comment = re.sub(r"[\n ]+$", '', comment)

        if len(comment) > 150:
            comment = comment[0:100] + '...'
        return comment
    return ''


def request_notification(**kwargs):
    if 'commits' not in kwargs and 'issue' not in kwargs:
        raise Exception("commits or issue expected")
    if 'dest' not in kwargs:
        raise Exception("destination expected")
    if 'recipient' not in kwargs:
        raise Exception("recipient expected")

    if type(kwargs['recipient']) is list:
        recipients = kwargs['recipient']
    else:
        recipients = [kwargs['recipient']]

    reqid = generate_reqid()
    dest = HostGroup.objects.get(name=kwargs['dest'])

    users = []
    for recp in recipients:
        try:
            user = User.objects.get(login=recp)
        except User.DoesNotExist:
            raise Exception("user %s doesn't exist" % recp)
        users += [user]

    for user in users:
        if 'commits' in kwargs and len(kwargs['commits']) > 0:
            for c in kwargs['commits']:
                if 'comment' in kwargs:
                    comment = kwargs['comment']
                else:
                    comment = default_comment(commit=c)
                record, _ = NotifyOnDeploy.objects.get_or_create(
                        commit = c,
                        recipient = user,
                        destination_group = dest,
                        defaults = {
                            'reqid': reqid,
                            }
                        )
                record.reqid = reqid
                record.comment = comment
                record.save()

        if 'issue' in kwargs and len(kwargs['issue']) > 0:
            if 'comment' in kwargs:
                comment = kwargs['comment']
            else:
                comment = default_comment(issue=kwargs['issue'])
            record, _ = NotifyOnDeploy.objects.get_or_create(
                    jira_issue = kwargs['issue'],
                    recipient = user,
                    destination_group = dest,
                    defaults = {
                        'reqid': reqid,
                        }
                    )
            record.reqid = reqid
            record.comment = comment
            record.save()


def remove_notification(**kwargs):
    if 'commits' not in kwargs and 'issue' not in kwargs:
        raise Exception("commits or issue expected")
    if 'dest' not in kwargs:
        raise Exception("destination expected")
    if 'recipient' not in kwargs:
        raise Exception("recipient expected")

    dest = HostGroup.objects.get(name=kwargs['dest'])
    user, _ = User.objects.get_or_create(login=kwargs['recipient'])

    if 'commits' in kwargs and len(kwargs['commits']) > 0:
        for c in kwargs['commits']:
            try:
                record = NotifyOnDeploy.objects.get(
                        commit = c,
                        recipient = user,
                        destination_group = dest,
                        )
                record.delete()
            except NotifyOnDeploy.DoesNotExist:
                pass

    if 'issue' in kwargs and len(kwargs['issue']) > 0:
        try:
            record = NotifyOnDeploy.objects.get(
                    jira_issue = kwargs['issue'],
                    recipient = user,
                    destination_group = dest,
                    )
            record.delete()
        except NotifyOnDeploy.DoesNotExist:
            pass

    return

def user_notifications(login, dest_groups=None):
    result = {}
    recipient, _ = User.objects.get_or_create(login=login)
    notifications = NotifyOnDeploy.objects.filter(recipient=recipient, commit__gte=0)
    if dest_groups:
        notifications = notifications.filter(destination_group__name__in=dest_groups)

    for el in notifications:
        dest_group = str(el.destination_group)
        if dest_group not in result:
            result[dest_group] = {}
        result[dest_group][el.commit] = 1

    return result


def commit_notifications(rev, dest_groups=None):
    rev = int(rev)
    notifications_by_rev = commit_notifications_mass([rev], dest_groups)
    return notifications_by_rev[rev]


def commit_notifications_mass(revs, dest_groups=None):
    notifications_by_rev = {}

    notifications = NotifyOnDeploy.objects.filter(commit__in=revs, commit__gte=0)
    if dest_groups:
        notifications = notifications.filter(destination_group__name__in=dest_groups)

    for notification in notifications:
        if notification.commit not in notifications_by_rev:
            notifications_by_rev[notification.commit] = {}
        if notification.destination_group.name not in notifications_by_rev[notification.commit]:
            notifications_by_rev[notification.commit][notification.destination_group.name] = []

        notifications_by_rev[notification.commit][notification.destination_group.name].append(notification.recipient)

    return notifications_by_rev


def user_notifications_by_issues(login, dest_groups=None):
    recipient, _ = User.objects.get_or_create(login=login)
    notifications = NotifyOnDeploy.objects.filter(recipient=recipient).filter(~Q(jira_issue=''))
    if dest_groups:
        notifications = notifications.filter(destination_group__name__in=dest_groups)

    return [el.jira_issue for el in notifications]

