# -* encoding: utf-8 -*-
from django.http import HttpResponse
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.db.models import Q
import math, sys, re


from django.conf import settings
from releaser.ptera.models import *
from releaser.releaseplanning.models import *
from releaser.ptera.notifications import request_notification, remove_notification
from releaser.rights.tools import allowed
import releaser.rights.tools


@login_required
@allowed(releaser.rights.tools.TEAM_RIGHTS)
def notify_on_deploy(r):
    issue = r.REQUEST.get('issue', '')
    dest = r.REQUEST.get('dest', 'production')
    commits = r.REQUEST.getlist('commit')

    if len(commits) == 0 and issue == '':
        return HttpResponse('NOOK', mimetype="application/javascript")
    else:
        request_notification(
                issue=issue,
                commits=commits,
                dest=dest,
                recipient=r.user.username,
                )

    path = r.REQUEST.get('retpath', '/svnlog')
    return redirect(path)


@login_required
@allowed(releaser.rights.tools.TEAM_RIGHTS)
def dont_notify_on_deploy(r):
    issue = r.REQUEST.get('issue', '')
    dest = r.REQUEST.get('dest', 'production')
    commits = r.REQUEST.getlist('commit')

    if len(commits) == 0 and issue == '':
        return HttpResponse('NOOK', mimetype="application/javascript")
    else:
        remove_notification(
                issue=issue,
                commits=commits,
                dest=dest,
                recipient=r.user.username,
                )

    path = r.REQUEST.get('retpath', '/svnlog')
    return redirect(path)


@login_required
@allowed(releaser.rights.tools.TEAM_RIGHTS)
def subscribe(r):
    issue = r.REQUEST.get('issue', '')
    commits = r.REQUEST.getlist('commit')
    dest = r.REQUEST.get('dest', '')
    subscribers_str = r.REQUEST.get('subscribers', '').strip()

    subscribers = re.split(u'[ ,:;]+', subscribers_str)
    subscribers = list(set(subscribers))
    subscribers = [s for s in subscribers if s != '']

    if len(commits) == 0:
        raise Exception("expecting some commits")
    if not dest:
        raise Exception("expecting destination host group")

    if subscribers > 0:
        request_notification(
            commits=commits,
            dest=dest,
            recipient=subscribers,
        )

    path = r.REQUEST.get('retpath', '/svnlog')
    return redirect(path)


@login_required
@allowed(['developer', 'manager', 'test_engineer'])
def subscription_form(r):
    commit = r.REQUEST.get('commit', '')
    dest = r.REQUEST.get('dest', '')
    dest_name = r.REQUEST.get('dest_name', dest)

    if not dest:
        raise Exception("expecting destination host group")

    subscribers = {}
    if commit != '':
        subscribers = releaser.ptera.notifications.commit_notifications(commit, [dest])

    return render_to_response('ptera/subscription_form.html',
            {
                'project_name': settings.NAME,
                'commit': commit,
                'dest': dest,
                'dest_name': dest_name,
                'subscribers': [u.login for u in subscribers.get(dest, [])],
            },
            context_instance=RequestContext(r)
            )

