# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'TaskToRelease'
        db.create_table('releaseplanning_tasktorelease', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('jira_issue', self.gf('django.db.models.fields.CharField')(max_length=50, db_index=True)),
            ('author', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('commit', self.gf('django.db.models.fields.IntegerField')(default=-1)),
            ('week', self.gf('django.db.models.fields.IntegerField')(default=10000, db_index=True)),
            ('niceness', self.gf('django.db.models.fields.IntegerField')(default=0)),
            ('type', self.gf('django.db.models.fields.IntegerField')(default=5)),
            ('status', self.gf('django.db.models.fields.IntegerField')(default=0)),
            ('plausibility', self.gf('django.db.models.fields.DecimalField')(default=0, max_digits=3, decimal_places=2)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('review', self.gf('django.db.models.fields.CharField')(max_length=500)),
            ('comment', self.gf('django.db.models.fields.TextField')()),
        ))
        db.send_create_signal('releaseplanning', ['TaskToRelease'])

        # Adding unique constraint on 'TaskToRelease', fields ['jira_issue', 'week']
        db.create_unique('releaseplanning_tasktorelease', ['jira_issue', 'week'])

        # Adding model 'Membership'
        db.create_table('releaseplanning_membership', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('task', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['releaseplanning.TaskToRelease'])),
            ('role', self.gf('django.db.models.fields.IntegerField')()),
        ))
        db.send_create_signal('releaseplanning', ['Membership'])

    def backwards(self, orm):

        # Removing unique constraint on 'TaskToRelease', fields ['jira_issue', 'week']
        db.delete_unique('releaseplanning_tasktorelease', ['jira_issue', 'week'])

        # Deleting model 'TaskToRelease'
        db.delete_table('releaseplanning_tasktorelease')

        # Deleting model 'Membership'
        db.delete_table('releaseplanning_membership')

    models = {
        'releaseplanning.membership': {
            'Meta': {'object_name': 'Membership'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'role': ('django.db.models.fields.IntegerField', [], {}),
            'task': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['releaseplanning.TaskToRelease']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"})
        },
        'releaseplanning.tasktorelease': {
            'Meta': {'unique_together': "(('jira_issue', 'week'),)", 'object_name': 'TaskToRelease'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'comment': ('django.db.models.fields.TextField', [], {}),
            'commit': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'jira_issue': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'}),
            'members': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'task_to_release'", 'symmetrical': 'False', 'through': "orm['releaseplanning.Membership']", 'to': "orm['users.User']"}),
            'niceness': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'plausibility': ('django.db.models.fields.DecimalField', [], {'default': '0', 'max_digits': '3', 'decimal_places': '2'}),
            'review': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'status': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'type': ('django.db.models.fields.IntegerField', [], {'default': '5'}),
            'week': ('django.db.models.fields.IntegerField', [], {'default': '10000', 'db_index': 'True'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['releaseplanning']
