# -*- coding:utf-8 -*-
from django.db import models
from datetime import datetime
from releaser.users.models import *

from django.conf import settings
from releaser.utils import make_display_url

TASK_ST_TAG = 'starred_task'

class TaskToRelease(models.Model):

    FUTURE_WEEK = 10000
    FAR_FUTURE_WEEK = 100000

    TYPE_FIRST = 1
    TYPE_NON_FIRST = 2
    TYPE_ANY = 5
    TYPE_ABOVE_PLAN = 9
    TYPE_CHOICES = (
        (TYPE_FIRST, 'first_release'),
        (TYPE_NON_FIRST, 'non_first_release'),
        (TYPE_ANY, 'any'),
        (TYPE_ABOVE_PLAN, 'above_the_plan'),
    )

    STATUS_NOT_DONE = 1
    STATUS_RELEASED = 7
    STATUS_COMMITTED = 3
    STATUS_NONE = 0
    STATUS_CHOICES = (
        (1, '(-)'),
        (7, '(+)'),
        (3, '(...)'),
        (0, '(?)'),
    )

    jira_issue = models.CharField( max_length = 50, db_index=True )
    author   = models.ForeignKey(User)
    members  = models.ManyToManyField(User, through='Membership', related_name='task_to_release')
    commit   = models.IntegerField(default=-1)
    week     = models.IntegerField(db_index=True, default=FUTURE_WEEK)
    niceness = models.IntegerField(default=0)
    type     = models.IntegerField(choices=TYPE_CHOICES, default=TYPE_ANY)
    status   = models.IntegerField(choices=STATUS_CHOICES, default=STATUS_NONE)
    plausibility = models.DecimalField(max_digits=3, decimal_places=2, default=0)
    title    = models.CharField( max_length = 100 )
    review   = models.CharField( max_length = 500 )
    comment  = models.TextField()
    class Meta:
        unique_together = (("jira_issue", "week"),)
    def member_logins(self):
        return [m.login for m in self.members.all()]
    def add_members(self, member_logins):
        member_logins = list(set(member_logins))
        new_members = []
        for l in member_logins:
            if l == '':
                continue
            new_members += [User.objects.get(login=l)]
        old_members = list(set(self.members.all()))
        for om in old_members:
            if not om in new_members:
                m = Membership.objects.filter(task = self, user = om)
                m.delete()
        for nm in new_members:
            if not nm in old_members:
                m = Membership(task = self, user = nm, role = 0)
                m.save()

    def __unicode__(self):
        return "%s: %s %s (%s)" % (self.week, self.jira_issue, self.title, self.status)
    def display_url(self):
        return make_display_url(self.jira_issue)


MEMBER_ROLE_CHOICES = (
    (1, 'server-side'),
    (7, 'client-side'),
    (3, 'manager'),
    (5, 'reviewer'),
    (5, 'test-engineer'),
    (0, 'other'),
)

class Membership(models.Model):
    user = models.ForeignKey(User)
    task = models.ForeignKey(TaskToRelease)
    role = models.IntegerField(choices=MEMBER_ROLE_CHOICES)

