# -* encoding: utf-8 -*-
from django.db.models import Q
import math, sys, re
from datetime import datetime, timedelta, date
from time import time

from django.conf import settings

from releaser.users.models import User

from releaser.releaseplanning.models import TaskToRelease
from releaser.releaseplanning.tools import current_week, week_title, tasks_waiting_for_release, title_by_task, time_appropriate_for, too_long_title


def get_recent_tasks(**kwargs):
    cweek = current_week()
    #sys.stderr.write("week %s \n" % (cweek))
    tasks = TaskToRelease.objects.all().filter(week__gt=cweek-20)

    for t in tasks:
        t.too_long = t.week >= cweek and too_long_title(t.title)
        if t.too_long:
            t.display_title = u"Длиннющее_название,_которое_никто_не_потрудился_сократить. Исправь сейчас!"

    tasks_by_week = {}
    for t in tasks:
        if t.week > TaskToRelease.FUTURE_WEEK:
            t.week = TaskToRelease.FAR_FUTURE_WEEK
        if t.week > cweek + 1 and t.week < TaskToRelease.FUTURE_WEEK:
            t.week = TaskToRelease.FUTURE_WEEK
        if not t.week in tasks_by_week:
            tasks_by_week[t.week] = []
        tasks_by_week[t.week] = tasks_by_week[t.week] + [ t ]
        t.status_text = t.get_status_display()

        if 'add_available_actions' in kwargs and kwargs['add_available_actions']:
            if t.week >= cweek:
                t.editable = True
            if t.week > cweek:
                t.changeable_niceness = True
            if t.week > cweek + 1 or t.week == cweek + 1 and time_appropriate_for('change_next_week_tasks'):
                if 'login' in kwargs and kwargs['login'] == t.author.login:
                    t.deletable = True
            if t.week >= cweek + 1 and t.week < TaskToRelease.FAR_FUTURE_WEEK and time_appropriate_for('change_next_week_tasks'):
                t.movable = True
                t.movable_to = cweek + 1 if t.week > cweek + 1 else TaskToRelease.FUTURE_WEEK
                t.move_text = "на след. неделю" if t.movable_to == cweek + 1 else "на потом"
            if t.week > cweek + 1:
                t.future_movable = 1
                t.future_movable_to = TaskToRelease.FAR_FUTURE_WEEK if t.week < TaskToRelease.FAR_FUTURE_WEEK else TaskToRelease.FUTURE_WEEK
                t.future_move_text = "на потом" if t.future_movable_to == TaskToRelease.FAR_FUTURE_WEEK else "скоро!"

    for w in tasks_by_week:
        tasks_by_week[w] = sorted(tasks_by_week[w], key=lambda k: k.niceness, reverse=True)

    weeks = []
    current_weeks = []
    future_weeks = []
    far_future_weeks = []
    past_weeks = []
    for w in sorted(tasks_by_week.keys(), reverse=True):
        planned_tasks = [t for t in tasks_by_week[w] if t.type != TaskToRelease.TYPE_ABOVE_PLAN]
        unplanned_tasks = [t for t in tasks_by_week[w] if t.type == TaskToRelease.TYPE_ABOVE_PLAN]
        week = {
                'tasks': tasks_by_week[w],
                'planned_tasks': planned_tasks,
                'unplanned_tasks': unplanned_tasks,
                }
        week['has_unplanned'] = len(week['unplanned_tasks']) > 0
        week['title'] = week_title(w)
        week['title_descriptive'] = week_title(w, 'descriptive')
        if w < cweek:
            past_weeks.append(week)
            week['type'] = 'past'
        elif w == cweek:
            current_weeks.append(week)
            week['type'] = 'current'
        elif w <= TaskToRelease.FUTURE_WEEK:
            future_weeks.append(week)
            week['type'] = 'future'
        else:
            far_future_weeks.append(week)
            week['type'] = 'far_future'
        #weeks.append(week)

    result = {
                'current_week': cweek,
                'current_weeks': current_weeks,
                'future_weeks': future_weeks,
                'far_future_weeks': far_future_weeks,
                'past_weeks': past_weeks,
            }
    return result

