# -* encoding: utf-8 -*-
#import datetime
from datetime import datetime, timedelta, date
from time import time
import re, string, os, sys

from django.utils.encoding import smart_str, smart_unicode

from django.conf import settings

from releaser.svnlog.models import SvnLog, SvnLogHotfix
from releaser.svnrelease.models import SvnRelease
from releaser.versionica.tools import parse_version
from releaser.releaseplanning.models import TaskToRelease
from releaser.metatracker.models import Issue
from startrek_client import Startrek
from releaser.startrek.tools import get_startrek_robot_token


APPROPRIATE_TIMES = {
        'change_next_week_tasks': ( "1 15:00", "6 17:30" ),
        'summarize_week': ( "5 17:00", "6 21:30" ),

        # TODO
        #'estimate_plausibility_current_week': ( "1 03:00", "1 12:00" ),
        #'estimate_plausibility_next_week': ( "5 18:00", "6 21:00" ),
        }

def time_appropriate_for(action):
    if action not in APPROPRIATE_TIMES:
        return False
    bounds = APPROPRIATE_TIMES[action]
    now = datetime.now()
    wd = now.weekday() + 1
    now_str = "%s %s" % (wd, now.strftime("%H:%M"))
    return now_str >= bounds[0] and now_str <= bounds[1]


def current_week():
    return int((time() + 3*86400) // (7*86400))


def week_bounds(w):
    tue_time = w * 604800 + 86400 # вторник
    day = date.fromtimestamp(tue_time)
    beg = day - timedelta(days=day.weekday())
    end = day + timedelta(days=(7-day.weekday()-3))
    return beg,end


def week_title(w, format=''):
    if w == TaskToRelease.FUTURE_WEEK:
        return "Скоро"
    if w == TaskToRelease.FAR_FUTURE_WEEK:
        return "Неопределенное будущее"
    bounds = week_bounds(w)
    beg = bounds[0]
    end = bounds[1]
    end_format = "%d.%m.%Y"
    beg_format = "%d.%m.%Y"
    if beg.year != end.year:
        beg_format = "%d.%m.%Y"
    elif beg.month != end.month:
        beg_format = "%d.%m"
    else:
        beg_format = "%d"
    range = "%s-%s" % (beg.strftime(beg_format), end.strftime(end_format))
    if format == 'descriptive':
        cw = current_week()
        desc = ''
        if w == cw :
            desc = "сейчас"
        elif w == cw + 1:
            desc = "следующая"
        return ( range if desc == '' else '%s (%s)' % (range, desc))
    else:
        return "Неделя %s" % range


def tasks_waiting_for_release():
    cw = current_week()
    # copy-paste из svnlog.view
    releases_list = list( SvnRelease.objects.all().order_by('-base_rev')[:5] )[:-1]
    last_release_base = releases_list[0].base_rev if len(releases_list) > 0 else 0
    svnlog_list = SvnLog.objects.filter(svnlogbranch__branch__path = settings.SVN_DEFAULT_BRANCH, rev__gt=last_release_base)
    rev_list = [l.rev for l in svnlog_list.order_by('-rev')[:1000]]
    tasks = TaskToRelease.objects.filter(week=cw, commit__in=rev_list )
    return [t.title if not too_long_title(t.title) else (u"Слишком длинное название задачи. Исправь сейчас на https://%s/releaseplanning !" % settings.RELEASER_DNS ) for t in tasks]


def title_by_task(id):
    try:
        # сначала пробуем вытащить заголовок из базы
        issue = Issue.objects.get(issue_id=id)
        summary = issue.summary
        if summary == '' or summary == 'fake':
            raise Issue.DoesNotExist
    except Issue.DoesNotExist:
        startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.STARTREK_CLIENT_USER_AGENT)
        summary = startrek.issues[id].summary

    # Сокращаем заголовок: выбираем несколько самых длинных слов
    #summary_words = re.split(u'[ ,\.:/]+', summary)
    #summary_words.sort(key = len, reverse=True)
    #n = 3 if len(summary_words) > 3 else -1
    #title_words = summary_words[0:n]
    #title = " ".join(title_words)

    return summary


def too_long_title(title):
    title_words = re.split(u'[ ,:/]+', title)
    title_words.sort(key = len, reverse=False)

    return len(title_words) > 4 or len(title_words) == 4 and len(title_words[0]) > 2


def normalize_nice(week):
    tasks = TaskToRelease.objects.filter(week=week).order_by('niceness')
    if len(tasks) == 0:
        return

    n = tasks[0].niceness - 10
    for t in tasks:
        if t.niceness < n + 3 or t.niceness > n + 30:
            t.niceness = n + 10
            t.save()
        n = t.niceness

    if tasks[0].niceness < -100:
        d = 0 - tasks[0].niceness
        for t in tasks:
            t.niceness += d
            t.save()

    return


def change_nice(task, delta):
    normalize_nice(task.week)

    tasks = TaskToRelease.objects.filter(week=task.week).order_by('niceness')

    if abs(delta) == 1:
        if delta == 1:
            upper_tasks = [t for t in tasks if t.niceness > task.niceness]
        else :
            tasks = tasks.order_by('-niceness')
            upper_tasks = [t for t in tasks if t.niceness < task.niceness]
        if len(upper_tasks) > 0:
            t = upper_tasks[0]
            n = t.niceness
            t.niceness = task.niceness
            task.niceness = n
            task.save()
            t.save()
    elif abs(delta) > 1:
        if delta > 0:
            # tasks[-1] здесь не работает,
            # Negative indexing is not supported
            # https://github.com/divio/django-cms/issues/1099
            # после обновления Джанги можно заменить tasks.count()-1 просто на -1
            task.niceness = tasks[tasks.count()-1].niceness + 5
        else:
            task.niceness = tasks[0].niceness - 5
    task.save()

    return

