# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'Right'
        db.create_table('rights_right', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('right', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('exclusive', self.gf('django.db.models.fields.BooleanField')(default=False)),
        ))
        db.send_create_signal('rights', ['Right'])

        # Adding model 'HasRight'
        db.create_table('rights_hasright', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('right', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['rights.Right'], max_length=100)),
        ))
        db.send_create_signal('rights', ['HasRight'])

        # Adding unique constraint on 'HasRight', fields ['user', 'right']
        db.create_unique('rights_hasright', ['user_id', 'right_id'])

    def backwards(self, orm):

        # Removing unique constraint on 'HasRight', fields ['user', 'right']
        db.delete_unique('rights_hasright', ['user_id', 'right_id'])

        # Deleting model 'Right'
        db.delete_table('rights_right')

        # Deleting model 'HasRight'
        db.delete_table('rights_hasright')

    models = {
        'rights.hasright': {
            'Meta': {'unique_together': "(('user', 'right'),)", 'object_name': 'HasRight'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'right': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['rights.Right']", 'max_length': '100'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"})
        },
        'rights.right': {
            'Meta': {'object_name': 'Right'},
            'exclusive': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'right': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['rights']
