# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding field 'Right.title'
        db.add_column('rights_right', 'title', self.gf('django.db.models.fields.CharField')(default='', max_length=100, null=True), keep_default=False)

        # Adding field 'Right.comment'
        db.add_column('rights_right', 'comment', self.gf('django.db.models.fields.TextField')(default='', max_length=8192, null=True), keep_default=False)

    def backwards(self, orm):

        # Deleting field 'Right.title'
        db.delete_column('rights_right', 'title')

        # Deleting field 'Right.comment'
        db.delete_column('rights_right', 'comment')

    models = {
        'rights.hasright': {
            'Meta': {'unique_together': "(('user', 'right'),)", 'object_name': 'HasRight'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'right': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['rights.Right']", 'max_length': '100'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"})
        },
        'rights.right': {
            'Meta': {'object_name': 'Right'},
            'comment': ('django.db.models.fields.TextField', [], {'default': "''", 'max_length': '8192', 'null': 'True'}),
            'exclusive': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'right': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'title': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'null': 'True'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['rights']
