# -*- coding:utf-8 -*-
from django.db import models
from releaser.users.models import User

class Right(models.Model):
    right = models.CharField( max_length = 100 )
    exclusive = models.BooleanField()
    title = models.CharField( max_length = 100, default='', null=True )
    comment = models.TextField(max_length=8*1024, default='', null=True)

    def __unicode__(self):
        return self.right

class HasRight(models.Model):
    user = models.ForeignKey(User)
    right = models.ForeignKey( Right, max_length = 100 )

    class Meta:
        unique_together = (("user", "right"),)
    def __unicode__(self):
        return "%s %s" % (self.user, self.right)

