# -* encoding: utf-8 -*-
from django.http import HttpResponse, Http404, HttpResponseNotFound
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.db.models import Q
import sys, json

from django.conf import settings
from releaser.rights.models import *
from releaser.rights.tools import allowed, has_right, exclusive_holder
from releaser.yambclient.client import YambClient

@login_required
def index(r):
    records = HasRight.objects.all().order_by('id')

    rights = Right.objects.all().order_by('right')

    vars = {
            'login': r.user.username,
            'records': records,
            'rights': rights,
            'may_delegate': has_right(r.user.username, ['developer', 'test_engineer', 'tabula_superuser']),
            'may_drop_any_right': has_right(r.user.username, 'tabula_superuser'),
            'may_edit_rights': has_right(r.user.username, ['tabula_superuser', 'release_manager']),

            'RM': '-',
            'REng': '-',
            'RQA': '-',
            }
    try:
        vars['RM'] = exclusive_holder("release_manager")
    except:
        pass
    try:
        vars['REng'] = exclusive_holder("release_engineer")
    except:
        pass
    try:
        vars['RQA'] = exclusive_holder("release_qa")
    except:
        pass

    return render_to_response('rights/index.html',
            vars,
            context_instance=RequestContext(r)
            )

def list(r):
    records = HasRight.objects.all().order_by('id')

    if 'as' in r.GET and r.GET.get('as', '').strip() == 'json':
        data = []
        for rec in records:
            data += [{
                'login': rec.user.login,
                'right': rec.right.right
                }]
        json_data = json.dumps(data, sort_keys=True)
        return HttpResponse(json_data, mimetype="application/javascript")

    raise Exception("Bad parameters")


@login_required
@allowed(['developer', 'test_engineer', 'tabula_superuser'])
def delegate(r):
    """
    параметры
    right -- название выдаваемого права
    login -- логин пользователя, которому выдается право
    autologin -- если 1, то параметр login игнорируется,
        право выдается текущему пользователю (из авторизации)
    exclusive -- "обновлять и исключительные права тоже"
    """
    right = r.REQUEST.get('right', '').strip()
    login = r.REQUEST.get('login', '').strip()
    autologin = r.REQUEST.get('autologin', '0').strip()
    exclusive = r.REQUEST.get('exclusive', '0').strip()

    if autologin == '1':
        login = r.user.username

    if right == '' or login == '':
        raise Http404

    user, _ = User.objects.get_or_create(login = login)
    right, _ = Right.objects.get_or_create(right = right)

    if right.exclusive and exclusive != '1':
        raise Http404 # TODO более информативное сообщение

    rec, _ = HasRight.objects.get_or_create(user = user, right = right)
    rec.save()

    if right.exclusive:
        old_records = HasRight.objects.filter(right=right).filter(~Q(user=user))
        yamb = YambClient()
        for to_login in [ rec.user.login for rec in old_records ]:
            to = to_login
            details = u"\nзапрос на передачу права поступил от %s" % r.user.username if r.user.username != login else ''
            msg = u"""(Табула) исключительное право '%s' перешло к пользователю %s %s""" % ( right, login, details )
            yamb.send_message(to, msg)
        old_records.delete()

    return redirect('/rights')


@login_required
def drop_right(r):
    login = r.REQUEST.get('login', '').strip()
    right_name = r.REQUEST.get('right', '').strip()

    if login != r.user.username and not has_right(r.user.username, 'tabula_superuser'):
        raise Http404

    if right_name == '':
        raise Http404

    try:
        right = Right.objects.get(right = right_name)
    except Right.DoesNotExist:
        return HttpResponseNotFound("can't find right %s" % right_name)

    if right.exclusive:
        return HttpResponseNotFound("can't delete an exclusive right")

    try:
        HasRight.objects.get(right=right, user__login=login).delete()
    except HasRight.DoesNotExist:
        return HttpResponseNotFound("can't find relevant record")

    return redirect('/rights')


@login_required
@allowed(['release_manager', 'tabula_superuser'])
def update_right(r):
    right = r.REQUEST.get('right', '').strip()
    title = r.REQUEST.get('title', '').strip()
    comment = r.REQUEST.get('comment', '').strip()

    ri = Right.objects.get(right=right)
    ri.title = title
    ri.comment = comment
    ri.save()

    return redirect('/rights')


@login_required
@allowed(['tabula_superuser'])
def create_role(r):
    right = r.REQUEST.get('right', '').strip()
    title = r.REQUEST.get('title', '').strip()
    comment = r.REQUEST.get('comment', '').strip()
    exclusive = r.REQUEST.get('exclusive', '').strip()
    sys.stderr.write("exclusive: %s, %s\n" % (exclusive, r.REQUEST.get('exclusive', '')))

    ri, created = Right.objects.get_or_create(right = right, exclusive = exclusive)
    if not created:
        raise Exception("role '%s' exists already" % right)

    ri.title = title
    ri.comment = comment
    ri.exclusive = exclusive
    ri.save()

    return redirect('/rights')

