# -*- coding:utf-8 -*-

from django.core.management.base import BaseCommand

from optparse import make_option
from sys import exit
import traceback

from releaser.scheduler.tasks_base import task_registry, tasks_by_launch_tags
from releaser.utils import locked_file

class Command(BaseCommand):
    help = "Watch the world and send the news"
    option_list = BaseCommand.option_list + (
        make_option('--name', action='store', dest='task_name', type='string',
            help='The task subroutine to run'),
        make_option('--launch-tag', action='store', dest='launch_tag', type='string',
            help='The task subroutine to run'),
        )

    def handle(self, **options):
        if not options['task_name'] and not options['launch_tag']:
            raise RuntimeError('either --name or --launch-tag is required')

        task_names = []
        if options['task_name']:
            task_names.append(options['task_name'])

        if options['launch_tag']:
            task_names = task_names + tasks_by_launch_tags[options['launch_tag']]['tasks']

        exit_status = 0
        for task_name in task_names:
            task = task_registry[task_name]
            with locked_file('task_' + task_name):
                try:
                    task['func']()
                except Exception:
                    print(traceback.format_exc())
                    exit_status = 1

        exit(exit_status)
