# -*- coding:utf-8 -*-

from django.conf import settings

from importlib import import_module
from pprint import pprint
import re

__all__ = ['task', 'task_registry', 'tasks_by_launch_tags', 'tasks_without_launch_tags']

# '<name>' : { 'func' : <task subroutine>, 'schedule' : '<cron schedule>', 'launch_tag' : '<launch tag>' }
# launch_tag необязательный
task_registry = {}

# '<launch_tag>' : { 'schedule' : '<cron schedule>', 'tasks' : [ '<name>', '<name>', ... ] }
tasks_by_launch_tags = {}

# '<name>', '<name>', ...
tasks_without_launch_tags = []

def task(**kwargs):
    def task_decorator(func):
        task_name = func.__name__

        if task_name in task_registry:
            raise RuntimeError('duplicate task name: %s' % event_type)

        registry_item = kwargs.copy()
        registry_item['func'] = func

        task_registry[task_name] = registry_item

        schedule = registry_item['schedule']

        if 'launch_tag' in registry_item:
            launch_tag = registry_item['launch_tag']

            if not re.match(r'^\w+$', launch_tag):
                raise RuntimeError('invalid launch_tag {launch_tag}'.format(launch_tag=launch_tag))

            if launch_tag in tasks_by_launch_tags:
                if tasks_by_launch_tags[launch_tag]['schedule'] != schedule:
                    raise RuntimeError('inconsistent schedule for launch tag %s' % launch_tag)

                tasks_by_launch_tags[launch_tag]['tasks'].append(task_name)
            else:
                tasks_by_launch_tags[launch_tag] = { 'schedule': schedule, 'tasks': [ task_name ] }
        else:
            tasks_without_launch_tags.append(task_name)

        return func
    return task_decorator


for app in settings.INSTALLED_APPS:
    if not app.startswith('releaser.'):
        continue

    try:
        import_module(app + '.tasks')
    except ImportError as error:
        if str(error) != 'No module named tasks':
            raise
