# -* encoding: utf-8 -*-
from django.http import HttpResponse
from django.shortcuts import render_to_response
from django.template import RequestContext
import json
import urllib2, re, itertools, datetime
from collections import defaultdict
import sys, re

from xml.etree.ElementTree import ElementTree

from django.conf import settings

def index(request):
    if 'compact' in request.GET:
        compact = 1
    else:
        compact = 0
    stash = {
        'direct_configuration': {'db_info': {}},
        'ppc_shards': [],
        'ppcdict': '',
        'compact': compact,
        }
    try:

        f = urllib2.urlopen("http://intapi.direct.yandex.ru/DirectConfiguration")
        direct_configuration = json.loads(f.read())

        for db in direct_configuration['db_info'].values():
            host = db['host']
	    if isinstance(host, list):
	        host = host[0]
            db['host_short'] = host.split('.')[0]

        # в шаблоне обратиться к ключу с двоеточиями -- непросто, поэтому заменяем двоеточия на _
        for name, val in sorted(direct_configuration['db_info'].items()):
            norm_name = name.replace(':', '_')
            stash['direct_configuration']['db_info'][norm_name] = val
            if re.match(r'^ppc_\d+$', norm_name):
                val['host_tiny'] = val['host_short'].replace('ppcdata', '')
                stash['ppc_shards'].append(val)
            elif norm_name == 'ppcdict':
                val['host_tiny'] = val['host_short'].replace('ppcdict-xtradb', '')
                stash['ppcdict'] = val
    except Exception, e:
        stash['error'] = e
    return render_to_response('screen/index.html', stash)


def events(request):
    f = urllib2.urlopen("https://golem.yandex-team.ru/events.sbml?priority=any&resp=%s&acknowledge=show&format=xml" % settings.GOLEM_RESP)
    events = []
    now = datetime.datetime.now()
    for e in ElementTree().parse(f).getiterator('event'):
        # skip broken events without start_time field
        if 'start_time' not in e.attrib:
            continue
        start_time = datetime.datetime.strptime(e.attrib['start_time'], '%Y-%m-%d %H:%M:%S')
        delta = now - start_time
        if delta.days > 0:
           ela = "%dd" %  delta.days
        elif delta.seconds > 60 * 60:
           ela = "%dh" % (delta.seconds / 60 / 60)
        else:
           ela = "%dm" % (delta.seconds / 60)
        events.append({
                'host': e.attrib['object_name'],
                'dc': e.attrib['object_location'],
                'err': e.attrib['eventtype'],
                'start_time': e.attrib['start_time'],
                'ela': ela,
                'log': e.attrib['last_automatic_eventhistory'],
                'reaction': e.attrib['last_manual_eventhistory'],
                })

    try:
        alive_status = urllib2.urlopen("http://direct.yandex.ru/alive").read()
        if alive_status != 'ok':
            events.append({'host': 'DIRECT', 'err': 'alive='+alive_status})
    except Exception, e:
        events.append({'host': 'DIRECT', 'err': 'alive='+str(e)})

    if settings.GOLEM_HOST_IGNORE_REGEXP is not None:
        hosts_re = re.compile(settings.GOLEM_HOST_IGNORE_REGEXP)
        events = [e for e in events if not hosts_re.search(e['host'])]
    grouped_events = defaultdict(lambda: [])
    for e in events:
        grouped_events[e['host']].append(e)
    return HttpResponse(
        json.dumps(grouped_events, sort_keys=True),
        mimetype='application/javascript'
        )

