# Django settings for releaser project.
# -*- encoding: utf-8 -*-

import os
from django_yauth.settings import *

import blackbox
blackbox.BLACKBOX_URL = 'http://blackbox.yandex-team.ru/blackbox'

APP_TYPES = ['default']

IGNORE_FEATURE = "tabula"

PASSPORT_CREATE = True

TABULA_UNITED = False

YAUTH_TYPE = 'intranet'
YAUTH_USE_NATIVE_USER = True
YAUTH_USE_SITES = False
YAUTH_CREATE_USER_ON_ACCESS = True

# урл svn-репозитория
#RELEASER_SVN = ''
#RELEASER_WEBSVN = ''
RELEASER_SVN_DIR = None

# куда отправлять копии ревью
#REVIEW_CC_EMAIL = ''
REVIEW_SUBJ_PREFIX = None

# настройки, связаные с jira
# wsdl jira
#JIRA_WSDL = 'https://jira-robot.yandex-team.ru/rpc/soap/jirasoapservice-readonly-aware?wsdl'
# пользователь, из-под которого ходим в жиру
#JIRA_USER = ''
# пароль пользователя
#JIRA_PASS = ''
# id созданного в жире фильтра, отбирающего релизные тикеты
#JIRA_RELEASES_FILTER_ID = 12810
# UA для обращений к Джире
USER_AGENT = 'Direct.Tabula'
JIRA_USER_AGENT = USER_AGENT
JIRA_DISPLAY_URL = 'https://jira.yandex-team.ru'

STAFF_API_URL = 'https://staff-api.yandex-team.ru/v3/'
STAFF_API_CLIENT_ID = '504b62db138a4b41808ba62b053e30b9'
STAFF_API_TOKEN_FILE = '/etc/direct-tokens/staff'

# файл с конфигом для yamb-бота robot-direct-notify
YAMB_BOT_CONFIG = '/etc/direct-chat-bot/yamb.yaml'

# настройки для jabber-уведомлений
#JABBER_USERNAME = ''
#JABBER_PASSWD = ''
#JABBER_RESOURCE = 'Direct python jabber client'
#JABBER_SERVER = 'yandex-team.ru'
#JABBER_XMPP_SERVER = ('xmpp.yandex-team.ru',5222)

# сервер и пакет, по которому определять "какая версия сейчас в продакшене"
#VERSIONICA_MAIN_PROD_SERVER = ''
#VERSIONICA_MAIN_PROD_PACKAGE = ''

ADMIN_MAIL = 'tabula-admin@yandex-team.ru'

CRON_ENV_VARS = "PYTHONPATH=/opt/direct-py/startrek-python-client-sni-fix"


RELEASER_MAX_DIFF_LEN = 1024*1024
FORCE_SCRIPT_NAME = ''

PROJECT_PATH = os.path.realpath(os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

UPLOADER_DIR = os.path.join(PROJECT_PATH, "releaser", "static", "upload")
UPLOADER_PATH = "/static/upload"

LOGIN_URL = '/login'

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ALLOWED_HOSTS = ['*']

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

with open('/etc/direct-tokens/mysql_tabula2', 'r') as f:
    mysql_password = f.read()
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',           # 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': 'releaser',             # Or path to database file if using sqlite3.
        'USER': 'tabula2',             # Not used with sqlite3.
        'PASSWORD': mysql_password,         # Not used with sqlite3.
        # возможные варианты для HOST:
        # ppctabula-mysql01i.ppc.yandex.ru
        # ppctabula-mysql01f.ppc.yandex.ru
        # ppctabula-mysql01h.ppc.yandex.ru
        'HOST': 'c-mdbkoevgq3b4go03p0vl.rw.db.yandex.net',             # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '3306'             # Set to empty string for default. Not used with sqlite3.
        }
}

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
        'LOCATION': '127.0.0.1:11211',
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'ru-ru'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = '/static/'

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 're^kzh3i1168!3(+q7z!kj!#c$)%@46ar^u49+@j_rly5k^+q4'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
#     'django.template.loaders.eggs.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    'django.middleware.transaction.TransactionMiddleware',
    'releaser.logcmd.middleware.LoggingMiddleware',
)

ROOT_URLCONF = 'releaser.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    PROJECT_PATH + '/releaser/templates'
)
TEMPLATE_CONTEXT_PROCESSORS = (
    'django.core.context_processors.media',
    #'django.core.context_processors.auth',
    'django.contrib.auth.context_processors.auth',
    'django_yauth.context.yauth',
    'releaser.context_processors.settings',
)

INSTALLED_APPS = (
    'django_yauth',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.admin',
    'releaser.ptera',
    'releaser.migrations',
    'releaser.hotfixing',
    'releaser.versionica',
    'releaser.svnlog',
    'releaser.svnreview',
    'releaser.svnrelease',
    'releaser.tracker_proxy',
    'releaser.common',
    #'releaser.release',
    'releaser.metatracker',
    'releaser.screen',
    'releaser.birthdays',
    'releaser.functests',
    'releaser.testupdate',
    'releaser.rights',
    'releaser.users',
    'releaser.releaseplanning',
    'releaser.zkbrowser',
    'releaser.uploader',
    'releaser.jabberclient',
    'releaser.yambclient',
    'releaser.logcmd',
    'releaser.flagman',
    'releaser.gap',
    'releaser.autobeta',
    'releaser.cifront',
    'releaser.statistics',
    'releaser.scheduler',
    'releaser.subscriptions',
    'releaser.testscriptrun',
    'south',
)

# название проекта
NAME = '"Безымянный"'
# файл логотипа
LOGO = 'tabula_main.png'
LOGO_NAVBAR = 'tabula_main_45.png'

# Показывать ли ссылку на Метатрекер
METATRACKER_ENABLED=False
# давать ли обновлять ТС
TESTUPDATE_ENABLED=False
TESTUPDATE_JIRA_COMMENTS_ENABLED=False
# Принимать ли версии пакетов с серверов
VERSIONICA_ENABLED=False
# браузер базы ZooKeeper
ZKBROWSER_ENABLED=False
# запуск функциональных тестов
FUNCTESTS_ENABLED=False
# Понедельное планирование запусков
RELEASEPLANNING_ENABLED=False
# Заказ хотфиксов
HOTFIXING_ENABLED=False
# хранение текстов миграций
MIGRATIONS_ENABLED=False
# "полезные ссылки"
BOOKMARKS_ENABLED=False
# отсутствия
GAP_ENABLED=False
# автобеты
AUTOBETA_ENABLED=False
AUTOBETA_FREQUENT_ACTIONS = []
AUTOBETAS_PER_HOST = 20
# запуск скрипта с оповещениями дежурного о неудачных сборках
FAILED_BUILDS_NOTIFY_ENABLED=False
# время жизни автобеты в днях
AUTOBETAS_LIFETIME = 30
# за сколько дней до истечения expiration_time подсвечивать автобету
AUTOBETA_WARNING_DAYS = 6
# давать ли обновлять приложения в тестовом мультиоблаке
CLOUD_TESTUPDATE_ENABLED=False

# апи вики
WIKI_API_URL = 'https://wiki.yandex-team.ru/_api/frontend/'
# таблица с дежурными по саппорту разработки директа
WIKI_DUTY_TABLE_URL = "direct/duty/infra"

GAP_API_URL = 'http://gap-api.yandex-team.ru/api'
#GAP_API_URL = 'http://gap.test.tools.yandex-team.ru/api'

#try:
#    from settings_local import *
#except ImportError:
#    pass

TESTSCRIPTRUN_ENABLED = False

BUILDBOT_URL = "http://ppcbuild.ppc.yandex.ru"

# настройки для работы со Стартреком
STARTREK_ROBOT_TOKEN_FILE = '/etc/direct-tokens/startrek'
STARTREK_DISPLAY_URL = 'https://st.yandex-team.ru'
STARTREK_CLIENT_USER_AGENT = USER_AGENT

# на каком хосте выполнять удаленный svn merge
HOST_FOR_SVN_MERGE = ''

SHOW_TEMP_DB_BLURB = False

SVNLOG_DEFAULT_APP_ID = 0
APPS_EXTRA = {
}

APPS_CONF_FILE = "/etc/yandex-direct/direct-apps.conf.yaml"
DEFAULT_RELEASES_TO_CHECK = 5

