# -*- encoding: utf-8 -*-

import re, sys
from django.conf import settings

# TODO переделать работу со статусами, т. к. Джира сейчас (2014-10) используется только в метатрекере
STR_FOR_STATUS = {
    'open': 'Open',
    'resolved': 'Resolved',
    'betaTested': 'Beta-tested',
    'needInfo': 'Need Info',
    'inProgress': 'In Progress',
    'inDevelopment': 'In Development',
    'closed': 'Closed',
    'new': 'New',
    'testing': 'Testing',
    'needAcceptance': 'Need Acceptance',
    'rmAcceptance': 'RM Acceptance',
    'readyToDeploy': 'Ready to deploy',
    'tested': 'Tested',
    'readyForTest': 'Ready for test',
    'inReview': 'In Review',
    'awaitingRelease': 'Awaiting release',
}

SIGN = u"----\nСкрипт tabula/%s"

# Для совместимости с существующим кодом.
def startrek_status_key_to_str(key):
    if key in STR_FOR_STATUS:
        return STR_FOR_STATUS[key]
    else:
        return "unknown (%s)" % key

token = None

def get_startrek_robot_token():
    global token
    if token is None:
        token = open(settings.STARTREK_ROBOT_TOKEN_FILE).readline().rstrip()
    return token

def last_releases_query(**O):
    if 'component' in O:
        return 'Queue: %s Type: release Components: "%s" Created: >= 2012-01-01 "Sort by": key desc' % (settings.TRACKER_QUEUE, O['component'])
    else:
        return 'Queue: %s Type: release "Sort by": key desc' % (settings.TRACKER_QUEUE)

def get_sign_comment(script_name):
    return SIGN % script_name

def get_recent_releases_st(startrek_obj, app_component, limit=10):
    return list(
        startrek_obj.issues.find('Queue: DIRECT Type: Release Components: "%s" "Sort by": key desc' % app_component)
    )[:limit]
