$(document).ready(function() {
    $('#comment_modal').on('show.bs.modal', function (event) {
        var caller = $(event.relatedTarget);
    
        var submit_button = $("#comment_submit_button");
        submit_button.attr('data-ticket', caller.attr("data-ticket"));
        submit_button.removeClass('btn-danger');
    
        if (caller.attr("data-metric")) {
            $("#modal_title").text("Комментарий для " + caller.attr("data-ticket") + ": " + caller.attr("data-metric"));
            $("#modal_textarea").val(caller.attr('data-comment'));
            $("#modal_textarea").prop("readonly", false);
            submit_button.attr('data-metric', caller.attr("data-metric"));
            submit_button.css('display', '');
            submit_button.text('Сохранить');
            submit_button.removeClass('btn-danger');
            $("#comment_close_button").text('Отменить');
        } else {
            $("#modal_title").text("Комментарий для " + caller.attr("data-ticket"));
            $("#modal_textarea").val($.map($("i.icon-" + caller.attr("data-ticket")),
                                           function(element) {
                                               var cur_el = $(element);
                                               if (cur_el.attr('data-metric') && cur_el.attr('data-comment')) {
                                                   return '### ' + cur_el.attr('data-metric') + ':\n' + cur_el.attr('data-comment');
                                               } else {
                                                   return "";
                                               }
                                           }).filter(function(v) { return v }).join('\n\n'));
            $("#modal_textarea").prop("readonly", true);
            submit_button.css('display', 'none');
            $("#comment_close_button").text('Закрыть');
        }
    });
});
function status(response) {
    if (response.status >= 200 && response.status < 300) {
        return Promise.resolve(response)
    } else {
        return Promise.reject(new Error(response.statusText))
    }
}

function json(response) {
    return response.json()
}

function send_review_comment() {
    $("#modal_textarea").prop('disabled', true);

    var button = $("#comment_submit_button");
    button.prop('disabled', true);

    var text = $("#modal_textarea").val();

    fetch("/statistics/add_review_comment?ticket="+button.attr('data-ticket')+'&metric='+button.attr('data-metric')+'&comment='+encodeURI(text), {credentials: "include"})
        .then(status)
        .then(json)
        .then(function(data) {
            if (!data['error']) {
                var icon = $("i[data-ticket='" + button.attr('data-ticket') + "'][data-metric='" + button.attr('data-metric') + "']");
                icon.attr("data-comment", text);
                if (!icon.hasClass("fa-2x") && text) {
                    icon.addClass("fa-2x");
                } else if (icon.hasClass("fa-2x") && !text) {
                    icon.removeClass("fa-2x");
                }
                $('#comment_modal').modal('toggle');
            } else {
                button.addClass('btn-danger');
                button.text('Ошибка! Пробовать снова');
                console.log(data['error']);
            }
        }).catch(function(error) {
            button.addClass('btn-danger');
            button.text('Ошибка! Пробовать снова');
            console.log('Request failed', error);
        })
        .finally(function () {
            $("#modal_textarea").prop('disabled', false);
            button.prop('disabled', false);
        });
}
