var refresh_timeout = 100;
var refresh_timer;

var switch_timeout = 60;
var switch_timer;

var base_period = 14400;
var period = base_period;

// Коды пульта
var IR_HOME = 36;
var IR_OK = 13;
var IR_UP = 38;
var IR_DOWN = 40;
var IR_RIGHT = 39;
var IR_LEFT = 37;

var $screens;
var $auto_screens;
var current_screen;
var items = [];
var additional_keys = {keys: {}, keycodes: {}};

var contrast_colors = ['4572A7', 'AA4643', '89A54E','80699B','3D96AE','DB843D','92A8CD','A47D7C','B5CA92','255297','8A2633','69853E','60497B','0D768E','AB641D','9288AD','745D5C','85AA72'];

var W = window.innerWidth;
var H = window.innerHeight;

var types = {
    'img': function (el, props) {
        $(el).html("<img src=''>");
        this.$img = $('img', el);

        if (props.a_href) {
            this.$img.wrap("<a href='' />");
            this.$a =  $('a', el);
        }

        this.refresh = function () {
            this.$img.attr('src', this._calc_href());
            if (props.a_href) {
                this.$a.attr('href', props.a_href());
            }
        };

        this._calc_href = function () {
                if (typeof(props.href) == 'function') {
                    return props.href(el);
                } else {
                    return props.href + '?' + Math.random();
                }
            };

        this.refresh();
    },
    'iframe': function (el, props) {
        $(el).html("<iframe src=''>");
        this.$iframe = $('iframe', el);

        this.refresh = function () {
            this.$iframe.width(props.get_width(el));
            this.$iframe.height(props.get_height(el));
            this.$iframe.attr('src', props.href(el));
        };

        this.refresh();
    },
    'alerts': function (el, props) {
        var $alerts = $('#alerts');
        this.old_height = $alerts.height();
        this.refresh = function () {
            if (! $('#data').data('compact')) {
                $.getJSON("/screen/events", null, function (data) {
                            var events = props.get_events_function(data);
                            if (events.length) {
                                var len = events.join(" ").replace(/<.*?>/g, '').length;
                                var font_size;
                                if (len < 60) {
                                    font_size = '300%';
                                } else if (len < 180) {
                                    font_size = '200%';
                                } else {
                                    font_size = '150%';
                                }
                                $(el).css("font-size", font_size);
                                $(el).html(events.join(" &nbsp;&nbsp; "));
                            } else {
                                $(el).css("font-size", "300%");
                                $(el).html("<span class=ok>нет проблем</span>");
                            }
                            if (this.old_height != $alerts.height()) {
                                this.old_height = $alerts.height();
                                //resize_items(); 
                            }

                            var details = '';
                            for(var host in data) {
                                details += '<tr><td colspan=3 class=host>' + host + '</td></tr>';
                                for(var i = 0; i < data[host].length; i++) {
                                    var ev = data[host][i];
                                    details += '<tr><td width=20%>' + ev.err + '</td><td width=10%>' + ev.ela.replace(/^(\S+).*/, "~$1") + '</td><td>' + ev.log + '</td></tr>';
                                }
                            }
                            if (details.length) {
                                $('#events_details').html("<table width=100%>"+details+"</table>");
                            } else {
                                $('#events_details').html("<span class=ok>нет проблем</span>");
                            }
                            
                        });

            }
        };
        this.refresh();
    },
};

function process_keypress(e) {
    //alert(e.keyCode);
    var key = String.fromCharCode(e.keyCode).toLowerCase();
    if (key >= '1' && key <= $auto_screens.size()) {
        activate_screen(key-0);
        schedule_switch();
    } else if (key == ' ' || e.keyCode == IR_RIGHT) {
        switch_screen(1);
        schedule_switch();
    } else if (e.keyCode == IR_LEFT) {
        switch_screen(-1);
        schedule_switch();
    } else if (e.keyCode == IR_OK) {
        document.location.reload();
    } else if (key == 'q' || key == 'w' || e.keyCode == IR_UP || e.keyCode == IR_DOWN) {
        change_period(key == 'q' || e.keyCode == IR_UP ? -1 : 1);
        schedule_refresh();
    } else if ( key == '0') {
        change_period(0);
        schedule_refresh();
    } else if (additional_keys.keys[key]) {
	toggle_hidden_screen(additional_keys.keys[key]);
    } else if (additional_keys.keycodes[e.keyCode]) {
	toggle_hidden_screen(additional_keys.keycodes[e.keyCode]);
    }
}
function activate_screen(num) {
    if ($auto_screens.size() < num) {
        alert('No screen #' + num);
        return;
    }
    $screens.hide();
    var cur_screen = $auto_screens.slice(num-1, num);
    cur_screen.show();
    if (cur_screen.hasClass('refresh_first')) {
        cur_screen.removeClass('refresh_first');
        refresh_items();
    }
    current_screen = num;
}
function change_period(i) {
    if (i == -1 && period > 300) {
        period = Math.floor(period / 2);
    } else if (i == 1 && period < base_period * 32768) {
        period = Math.floor(period * 2);
    } else {
        period = base_period;
    }
    refresh_items();
}

function toggle_hidden_screen($hidden_screen) {
    if ($hidden_screen.is(":hidden")) {
	$screens.hide();
	$hidden_screen.show();
	schedule_switch(20);
    } else {
	activate_screen(current_screen);
	schedule_switch();
    }
}

function init_items() {
    $('.ritem').each(function (i, el) {
        var props = el.onclick();
        if (types[props['type']]) {
            var obj = new types[props['type']](el, props);
            items.push(obj);
        } else {
            alert('undefined type ' + props['type']);
        }
    });
}
function refresh_items() {
    for(var i = 0;i < items.length; i++) {
        items[i].refresh();
    }
}
function resize_items() {
    resize_screen();
    for(var i = 0;i < items.length; i++) {
        if (items[i].resize) {
            items[i].resize();
        } else {
            items[i].refresh();
        }
    }
}
function resize_screen() {
    $screens.width(window.innerWidth - 10);
    var screen_height = window.innerHeight;
    if (! $('#data').data('compact')) {
        screen_height = screen_height - 40 - $("#hint").height() - $("#alerts").height();
    }
    $screens.height(screen_height-20);
    //$('#help_screen').height(screen_height);
    //$('#events_screen').height(screen_height-20);
}
function schedule_refresh() {
    if (refresh_timer) clearTimeout(refresh_timer);
    refresh_timer = setTimeout(function () {refresh_items(); schedule_refresh();}, refresh_timeout * 1000);
}
function schedule_switch(timeout) {
    if (switch_timer) clearTimeout(switch_timer);
    if (timeout == null) timeout = switch_timeout;
    switch_timer = setTimeout(function () {switch_screen(1); schedule_switch();}, timeout * 1000);
}

function switch_screen(i) {
    if (i > 0) {
        activate_screen(current_screen < $auto_screens.size() ? current_screen + 1 : 1);
    } else {
        activate_screen(current_screen > 1 ? current_screen - 1 : $auto_screens.size());
    }
}

function ritem_chart2(graphid, legend_lines) {
    return {
           type: 'img',
           a_href: function () { return 'http://ztop.yandex-team.ru/view/charts?graphid='+graphid+'&period='+period+'&from=0' },
           href: function (el) {
                      var $screen = $(el).parents().filter(".screen");
                      return 'http://ztop.yandex-team.ru/index.php?page=chart2&graphid=' + graphid + '&period=' + period + '&stime=&from=0&submenu=charts' +
                                       '&width='+Math.floor(($screen.width()-20) / 2 - 80) + 
                                       '&height=' + Math.floor(($screen.height()-20) / 2 - 120 - legend_lines * 14) + 
                                       '&rnd=' + Math.random();
                 },
           };
}

function ritem_advbuf_chart(graphid, legend_lines, w, h, time_factor) {
    w = w || 2; // сколько графиков по горизонтали
    h = h || 2; // сколько графиков по вертикали
    time_factor = time_factor || 1; // на сколько умножается время
    return {
        type: 'img',
        a_href: function () { 
            return 'http://advmonbuf.yandex.ru/cacti/graph.php?action=view&local_graph_id='+graphid+'&rra_id=all';
        },
        href: function (el) {
            var $screen = $(el).parents().filter(".screen");
            var time = Math.floor(new Date().getTime() / 1000);
            return 'http://advmonbuf.yandex.ru/cacti/graph_image.php?' +
                'local_graph_id=' + graphid +
                '&graph_width=' + Math.floor(($screen.width()-20) / w - 80) + 
                '&graph_height=' + Math.floor(($screen.height()-20) / h - 150 - legend_lines * 20) + 
                '&graph_start=' + (time - time_factor * period) +
                '&graph_end=' + time +
                '&rnd=' + Math.random();
        },
    };
}

function ritem_graphite_chart(url, legend_lines, w, h, time_factor) {
    w = w || 2; // сколько графиков по горизонтали
    h = h || 2; // сколько графиков по вертикали
    time_factor = time_factor || 1; // на сколько умножается время
    return {
        type: 'img',
        a_href: function () { 
            return url.replace('/render', '/composer');
        },
        href: function (el) {
            var $screen = $(el).parents().filter(".screen");
            var time = Math.floor(new Date().getTime() / 1000);
            return url + 
                (url.match(/colorList/) ? '' : '&colorList=' + contrast_colors.join('%2C')) + 
                '&width=' + Math.floor(($screen.width()-20) / w) + 
                '&height=' + Math.floor(($screen.height()-120) / h) + 
                '&from=-' + Math.floor(time_factor*period) + 'seconds' +
                '&rnd=' + Math.random();
        },
    };
}

function ritem_solomon_chart(url, legend_lines, w, h, time_factor) {
    w = w || 2; // сколько графиков по горизонтали
    h = h || 2; // сколько графиков по вертикали
    time_factor = time_factor || 1; // на сколько умножается время
    return {
        type: 'iframe',
        get_width: function (el) {
            var $screen = $(el).parents().filter(".screen");
            return Math.floor(($screen.width()-20) / w);
        },
        get_height: function (el) {
            var $screen = $(el).parents().filter(".screen");
            return Math.floor(($screen.height()-120) / h);
        },
        href: function (el) {
            var $screen = $(el).parents().filter(".screen");
            return url + '&b=' + Math.floor(time_factor*period) + 's';
        },
    };
}

function ritem_graphite_la_chart(hosts, legend_lines, w, h, time_factor) {
    var targets = [];
    var las = hosts.length == 1 ? [1,5,15] : [1];
    var color_list = hosts.length == 1 ? ['c44437', '7bb865', '5d72dc'] : contrast_colors;
    var line_width = hosts.length == 1 ? 1 : 2;
    for(var i = 0; i < hosts.length; i++) {
        var host_graphite = hosts[i].replace(/\./g, '_');
        var host_short = hosts[i].replace(/\..*/g, '');
        las.forEach(function(la) {
                targets.push("target=alias(one_min."+host_graphite+".la."+la+"%2C%20'"+(hosts.length == 1 ? '' : host_short+", ")+"la%20"+la+"')")
            });
    }
    return ritem_graphite_chart("//ppcgraphite.yandex.ru/render/?" + targets.join("&") + "&yMin=0&fgcolor=000000&bgcolor=FFFFFF&minorGridLineColor=FFFFFF&majorGridLineColor=969696&lineWidth="+line_width+"&colorList=" + color_list.join(','), legend_lines, w, h, time_factor);
}

$(window).load(function () {
    $screens = $(".screen");
    $auto_screens = $screens.filter(":not(.hidden)");

    $screens.each(function(i, e) {
	    var d = $(e).data('options');
	    if (d && d['keys']) {
		d.keys.forEach(function (key) {
			additional_keys.keys[key] = $(e);
		    }
		    );
	    }
	    if (d && d['keycodes']) {
		d.keycodes.forEach(function (keycode) {
			additional_keys.keycodes[keycode] = $(e);
		    }
		    );
	    }
	});

    $(document).keydown(process_keypress);
    $(window).resize(resize_items);

    base_period = $('#data').data('period');
    period = base_period;

    resize_screen();
    init_items();
    activate_screen(1);
    schedule_refresh();
    schedule_switch();
});
