default_style = {
    "statuses": {
        "Open": {"color":"#DD88EE"},
        "Resolved": {"color":"#BBFFBB"},
        "Beta-tested": {"color":"#88EE22"},
        "Tested": {"color":"#22EE88"},
        "Closed": {"color":"gray"},
        "Need Info": {"color":"yellow"},
        "UNKNOWN": {"color":"#FFA57F"}
    },
    "markers": {
        "Now": {"color": "red"}, 
        "Need Acceptance": {"color": "green"}
    }
};

function timeline_html(data, template) {
    Handlebars.registerHelper('p', function(time) {
            // calculate width percents for elements style
            return( (100*time/data.time_span).toFixed(2) + '%' );
        });
    Handlebars.registerHelper('st', function(status) {
            // prepare status for using in css classes
            return status.replace(/ /g, '-');
        });
    // enrich data before templating
    data.items.forEach(function(item) {
            if (!item.time_span ){
                item.time_span = data.time_span
            }
            item.full = item.time_span >= data.time_span;
            if (item.time_span >= data.time_span && item.timeline.length > 0) {
                item.status = item.timeline[item.timeline.length - 1].new_status;
            }
            for(var j = 0; j < item.timeline.length; j++) {
                if (item.timeline[j].time > item.time_span){
                    break;
                }
                item.timeline[j].visible = 1;
                item.timeline[j].time_end = 
                    j < item.timeline.length - 1 
                    ? item.timeline[j+1].time  
                    : data.time_span;
                if ( item.timeline[j].time_end > item.time_span ){
                    item.timeline[j].time_end = item.time_span;
                }
                item.timeline[j].time_dur = item.timeline[j].time_end - item.timeline[j].time;
            }
        });
    return template(data);
}

function randomColor() {
    var letters = '0123456789ABCDEF'.split('');
    var color = '#';
    for (var i = 0; i < 6; i++ ) {
        color += letters[Math.round(Math.random() * 15)];
    }
    return color;
}

function timeline_graph(data, style) {
    style = default_style;
    var canvas = document.getElementById('canvas');
    canvas.height = (data.items.length + 2) * 25;
    var ctx = canvas.getContext("2d");
    ctx.save();
    var graph_width = 1000;
    var hscale = function(length){
        return Math.round(graph_width*length/data.time_span);
    }
    var bar = function(x,y,width, heigth){
        ctx.fillRect(hscale(x),y,hscale(width),25);
        ctx.strokeRect(hscale(x),y,hscale(width),25);
    };

    ctx.clearRect(0,0,1200,1500);
    ctx.scale(1,1);

    ctx.strokeStyle = "black";
    ctx.lineWidth = 3;
    ctx.lineCap = "round";

    ctx.translate(10,0);
    ctx.save();
    for (i = 0; i < data.items.length ; i++){
        ctx.translate(0,25);
        var item = data.items[i];
        if(! item.hasOwnProperty("time_span") ){
            item.time_span = data.time_span;
        }

        for (j = 0 ; j < item.timeline.length ; j++){
            if(item.timeline[j].time > item.time_span){
                break;
            }
            var start = item.timeline[j].time;
            var end = j < item.timeline.length - 1 ? item.timeline[j+1].time : item.time_span;
            end = Math.min(item.time_span, end);
            var new_status = item.timeline[j].new_status;
            if( style.statuses.hasOwnProperty(new_status)){
                ctx.fillStyle = style.statuses[new_status]["color"];
            } else if ( style.statuses.hasOwnProperty("UNKNOWN") ) {
                ctx.fillStyle  = style.statuses["UNKNOWN"]["color"];
            } else {
                ctx.fillStyle  = randomColor();
            }
            bar( start, 0, end-start, 25 );
        }
        ctx.fillStyle = "black";
        ctx.font = "bold 10pt Arial";
        ctx.textBaseline = "bottom";
        ctx.fillText(item.title, 0, 22);
    }
    ctx.restore();

    ctx.save();
    ctx.lineWidth = 3;
    ctx.lineCap = "round";
    ctx.font = "bold 10pt Arial";
    ctx.textBaseline = "bottom";
    for (i = 0; i < data.markers.length ; i++) {
        ctx.beginPath();
        marker = data.markers[i]; 
        ctx.strokeStyle = style.markers[marker.type]["color"];
        ctx.moveTo(hscale(marker.time), 0);
        ctx.lineTo(hscale(marker.time), (data.items.length + 2) * 25 );
        ctx.stroke();
        ctx.fillStyle = style.markers[marker.type]["color"];
        ctx.fillText(marker.title, hscale(marker.time)+3, 17);
    }
    ctx.restore();

    ctx.save();
    ctx.lineWidth = 3;
    ctx.lineCap = "round";
    ctx.strokeStyle = "black";
    ctx.font = "bold 10pt Arial";
    ctx.textBaseline = "bottom";
    ctx.fillStyle = "black";
    for (i = 0; i < data.scale.length ; i++) {
        ctx.beginPath();
        marker = data.scale[i]; 
        ctx.moveTo(hscale(marker.time), 3);
        ctx.lineTo(hscale(marker.time), 15);
        ctx.stroke();
        ctx.fillText(marker.title, hscale(marker.time)+3, 17);
    }
    ctx.restore();


    ctx.restore();
}
