var ISSUE_KEYS_PER_REQUEST = 50;

var tracker_request_sended = false;
function get_tracker_statuses() {
    if (tracker_request_sended) return;

    var issues = {};
    var issues_keys = [];

    $('.jLink').each(function () {
        var j = this.href.replace(/.*?([a-z0-9-]+)$/i, "$1");
        if (j.match(/-0$/)) return;
        if (!issues[j]) {
	    issues_keys.push(j);
            issues[j] = [];
        }
        issues[j].push(this);
    });

    $('.filter-issues-count[class*="status-count-"]').each(function(){ $(this).html(0) });

    app = $('[name ="current_app"]').val();
    app_translation = {
        'direct': ['', 'perl'],
        'dna': ['', 'dna'],
        'java-web': ['', 'web']
    };
    if ( app in app_translation ){
        apps_for_statuses = app_translation[app];
    } else {
        apps_for_statuses = [''];
    }
    for ( app_for_status of apps_for_statuses )
        $.ajax('/tracker/issue_status', {
            'type': 'POST',
            'traditional': true,
            'dataType': 'json',
            'data': {
            'issue': issues_keys,
            'for_app': app_for_status
            },
            }
        ).done(function(data) {
            app_for_status = data.app;
            var status_stats = {};
            for(var i = 0; i < issues_keys.length; i++) {
            var key = issues_keys[i];
            var status = data.data[key];
            if (status in status_stats) {
                status_stats[status]++;
                    } else {
                status_stats[status]=1;
            }
            if (status) {
                var status_class;
                if (app_for_status != ''){
                    status_class = 'jApp-'+status.replace(/ /g, '-');
                } else {
                    status_class = 'jStatus j'+status.replace(/ /g, '-');
                }
                $(issues[key]).attr('title', status).addClass(status_class);
            }
            }
            for(status in status_stats) {
            try {
                $('.status-count-'+status.replace(/ /g, '-')).html(status_stats[status]);
            } catch(e){
                // неизвестные статусы игнорируем
            }
            }
        });
    
    tracker_request_sended = true;
}

var COOKIE_OPTIONS = { path: '/', expires: 3650 };
var COOKIE_NAME = 'releaser_dont_use_tracker';
function process_tracker_checkbox() {
    if ($('#use_tracker').attr('checked')) {
        $.cookie(COOKIE_NAME, 0, COOKIE_OPTIONS);
        get_tracker_statuses();
    } else {
        $.cookie(COOKIE_NAME, 1, COOKIE_OPTIONS);
    }
}

$(document).ready( function (){
    if ($.cookie(COOKIE_NAME) == 1) {
        $('#use_tracker').attr('checked', false);
    } else {
        $('#use_tracker').attr('checked', true);
        get_tracker_statuses();
    }
    $('#use_tracker').change(process_tracker_checkbox);
});

