from django.db import models


class ReleaseStatistics(models.Model):
    ticket = models.CharField(max_length=20)
    metric_name = models.CharField(max_length=50)
    value = models.BigIntegerField(default=0)
    comment = models.CharField(max_length=200, default="")

    class Meta:
        unique_together = (('ticket', 'metric_name'), )

    def __unicode__(self):
        return u'%s: %s = %d (%s)' % (self.ticket, self.metric_name, self.value, self.comment)


class ReleaseStatisticsComments(models.Model):
    release_stats = models.OneToOneField('ReleaseStatistics')
    review_comment = models.TextField()
