# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Subscription'
        db.create_table(u'subscriptions_subscription', (
            ('sub_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('owner', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('event_type', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('params', self.gf('django.db.models.fields.CharField')(max_length=250)),
            ('notification_type', self.gf('django.db.models.fields.IntegerField')()),
            ('recipient', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('notify_once', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('creation_time', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('expiration_time', self.gf('django.db.models.fields.DateTimeField')(default=None, null=True)),
        ))
        db.send_create_signal(u'subscriptions', ['Subscription'])

        # Adding model 'NotificationLog'
        db.create_table(u'subscriptions_notificationlog', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('event_type', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('event_data', self.gf('django.db.models.fields.TextField')()),
            ('subscription_event_type', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('subscription_params', self.gf('django.db.models.fields.CharField')(max_length=250)),
            ('notification_type', self.gf('django.db.models.fields.IntegerField')()),
            ('recipient', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('notification_content', self.gf('django.db.models.fields.TextField')()),
        ))
        db.send_create_signal(u'subscriptions', ['NotificationLog'])


    def backwards(self, orm):
        # Deleting model 'Subscription'
        db.delete_table(u'subscriptions_subscription')

        # Deleting model 'NotificationLog'
        db.delete_table(u'subscriptions_notificationlog')


    models = {
        u'subscriptions.notificationlog': {
            'Meta': {'object_name': 'NotificationLog'},
            'event_data': ('django.db.models.fields.TextField', [], {}),
            'event_type': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'notification_content': ('django.db.models.fields.TextField', [], {}),
            'notification_type': ('django.db.models.fields.IntegerField', [], {}),
            'recipient': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'subscription_event_type': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'subscription_params': ('django.db.models.fields.CharField', [], {'max_length': '250'})
        },
        u'subscriptions.subscription': {
            'Meta': {'object_name': 'Subscription'},
            'creation_time': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'event_type': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'expiration_time': ('django.db.models.fields.DateTimeField', [], {'default': 'None', 'null': 'True'}),
            'notification_type': ('django.db.models.fields.IntegerField', [], {}),
            'notify_once': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'owner': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['users.User']"}),
            'params': ('django.db.models.fields.CharField', [], {'max_length': '250'}),
            'recipient': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'sub_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        u'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['subscriptions']