# -*- coding:utf-8 -*-

from django.db import models

from releaser.users.models import User

class Subscription(models.Model):
    NOTIFICATION_TYPE_YAMB   = 1
    NOTIFICATION_TYPE_EMAIL    = 2
    NOTIFICATION_TYPE_STARTREK = 3

    NOTIFICATION_TYPE_CHOICES = [
        (NOTIFICATION_TYPE_YAMB, 'yamb'),
        (NOTIFICATION_TYPE_EMAIL, 'email'),
        (NOTIFICATION_TYPE_STARTREK, 'startrek'),
        ]

    sub_id = models.AutoField(primary_key=True)
    owner = models.ForeignKey(User)
    event_type = models.CharField(max_length=20)
    params = models.CharField(max_length=250)
    notification_type = models.IntegerField(choices=NOTIFICATION_TYPE_CHOICES)
    recipient = models.CharField(max_length=50)
    notify_once = models.BooleanField(default=False)
    creation_time = models.DateTimeField(auto_now_add=True)
    expiration_time = models.DateTimeField(null=True, default=None)

    @property
    def form_key(self):
        return '{uid}:{event_type}:{params}:{notification_type}:{recipient}:{notify_once}'.format(
            uid=self.owner.uid,
            event_type=self.event_type,
            params=self.params,
            notification_type=self.notification_type,
            recipient=self.recipient,
            notify_once=self.notify_once,
            )

class NotificationLog(models.Model):
    id = models.AutoField(primary_key=True)
    event_type = models.CharField(max_length=20)
    event_data = models.TextField()
    subscription_event_type = models.CharField(max_length=20)
    subscription_params = models.CharField(max_length=250)
    notification_type = models.IntegerField(choices=Subscription.NOTIFICATION_TYPE_CHOICES)
    recipient = models.CharField(max_length=50)
    notification_content = models.TextField()
