# -*- coding:utf-8 -*-

from django.conf import settings

from releaser.subscriptions.events_base import event_registry

def subscription_display_str(sub):
    return u'{sub_display} ({notification_type})'.format(
        # магия делегирования: чтобы получить описание, ищем по строковому типу
        # класс события и просим описание у него
        # event_registry[sub.event_type] - метаобъект или "класс как объект"
        #     (например, если event_type = 'example', метаобъект будет ExampleEvent)
        sub_display=event_registry[sub.event_type].display_subscription(sub),
        notification_type=sub.get_notification_type_display(),
        )
