# -* encoding: utf-8 -*-

from django.contrib.auth.decorators import login_required
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext

from releaser.subscriptions.models import Subscription
from releaser.subscriptions.utils import subscription_display_str
from releaser.users.models import User

@login_required
def index(r):
    user, _ = User.objects.get_or_create(login=r.user)

    default_subs = get_default_user_subs(user)

    user_subs = Subscription.objects.filter(owner=user)
    user_subs_set = set([ sub.form_key for sub in user_subs ])

    subs_show = []
    for sub in default_subs:
        sub_str = sub.form_key
        sub_display = subscription_display_str(sub)
        subs_show.append({ 'sub_str': sub_str, 'sub_display': sub_display, 'on': sub_str in user_subs_set })

    return render_to_response('subscriptions/index.html',
        {
            'subs': subs_show,
        },
        context_instance=RequestContext(r)
    )

@login_required
def save(r):
    user, _ = User.objects.get_or_create(login=r.user)

    default_subs = get_default_user_subs(user)
    default_subs_set = set([ sub.form_key for sub in default_subs ])

    user_subs = Subscription.objects.filter(owner=user)
    user_subs_set = set([ sub.form_key for sub in user_subs ])

    form_key_prefix = 'sub:'
    form_subs_set = set([ s[len(form_key_prefix):] for s in r.POST if s.startswith(form_key_prefix) ])

    sub_ids_to_delete = []
    for sub in user_subs:
        if sub.form_key in default_subs_set and sub.form_key not in form_subs_set:
            sub_ids_to_delete.append(sub.pk)

    Subscription.objects.filter(pk__in=sub_ids_to_delete).delete()

    for sub in default_subs:
        if sub.form_key in form_subs_set and sub.form_key not in user_subs_set:
            sub.save()

    return redirect('/subscriptions/')

def get_default_user_subs(user):
    user_yamb = user.login
    return [
        Subscription(owner=user, event_type='open_release_tickets', params='', notification_type=Subscription.NOTIFICATION_TYPE_YAMB, recipient=user_yamb),
        Subscription(owner=user, event_type='limtest_request', params='', notification_type=Subscription.NOTIFICATION_TYPE_YAMB, recipient=user_yamb),
        Subscription(owner=user, event_type='limtest_request', params='', notification_type=Subscription.NOTIFICATION_TYPE_EMAIL, recipient=user.login + '@yandex-team.ru'),
        Subscription(owner=user, event_type='trunk_build_failed', params='', notification_type=Subscription.NOTIFICATION_TYPE_YAMB, recipient=user_yamb),
    ]
