# -*- coding:utf-8 -*-

from django.core.management.base import BaseCommand
from django.db import models
from django.conf import settings

from releaser.yambclient.client import YambClient
from releaser.svnlog.models import SvnLog
from releaser.cifront.models import BuildBotSingleBuild
from releaser.svnlog.tools import get_new_release_base
from releaser.startrek.tools import get_startrek_robot_token
import json
import datetime
import urllib2


class Command(BaseCommand):
    help = "Check last commit for failed builds and notify duty"

    PREFIX_FOR_MESSAGE = 'direct-dev:svnlog\n'

    def get_duty_from_wiki(self, table_url = ''):
        req = urllib2.Request(settings.WIKI_API_URL + settings.WIKI_DUTY_TABLE_URL + '/.grid?format=json')
        req.add_header('Content-Type', 'application/json')
        req.add_header('Authorization', 'OAuth ' + get_startrek_robot_token())
        duty = json.loads(urllib2.urlopen(req).read())['data']['rows'][-1][3]['raw']
        if duty.find('staff:') != -1:
            duty = duty[6:]
        return duty

    def handle(self, **options):
        yamb = YambClient()
        duty = self.get_duty_from_wiki()

        duty = 'lena-san'

        last_commit = SvnLog.objects.filter(svnlogbranch__branch__path = settings.SVN_DEFAULT_BRANCH).last()
        last_rev = last_commit.rev
        last_revtime = last_commit.revtime
        build_results = BuildBotSingleBuild.objects.filter(rev=last_rev).select_related('builder__name')

        newest_results = {}
        for b in build_results:
            newest_results[b.builder.name] = b

        failed_builds = [newest_results[b].builder.name for b in newest_results if newest_results[b].status == BuildBotSingleBuild.BUILD_STATUS_FAIL]
        unknown_builds = [newest_results[b].builder.name for b in newest_results if newest_results[b].status == BuildBotSingleBuild.BUILD_STATUS_UNKNOWN]

        # если в базе долгое время нет данных билдов или есть неизвестные, то это плохо
        if (not build_results or unknown_builds) and (datetime.datetime.now() - last_revtime).total_seconds() // 60 > 15:
            if not build_results:
                yamb.send_message(duty, u"%sВ базе нет данных о тестах для ревизии %s" % (self.PREFIX_FOR_MESSAGE, last_rev))
            else:
                yamb.send_message(duty, u"%sДля последнего коммита %s нет данных некоторых тестов:\n%s" % (self.PREFIX_FOR_MESSAGE, last_rev, "\n".join(uknown_builds)))
            exit(0)

        # если есть упавшие тесты, то отправляем оповещение дежурному
        if failed_builds:
            yamb.send_message(duty, u"%sНа последнем коммите %s упали некоторые тесты, надо разобраться:\n%s/cifront/commit/%s\n%s" % (self.PREFIX_FOR_MESSAGE,
                                                                                                                                       last_rev,
                                                                                                                                       "https://" + settings.RELEASER_DNS,
                                                                                                                                       last_rev,
                                                                                                                                       "\n".join(failed_builds)))

        return
