# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'SvnAuthor'
        db.create_table('svnlog_svnauthor', (
            ('author_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('login', self.gf('django.db.models.fields.CharField')(unique=True, max_length=128)),
        ))
        db.send_create_signal('svnlog', ['SvnAuthor'])

        # Adding model 'SvnLog'
        db.create_table('svnlog_svnlog', (
            ('rev', self.gf('django.db.models.fields.IntegerField')(primary_key=True)),
            ('revtime', self.gf('django.db.models.fields.DateTimeField')()),
            ('author', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnAuthor'])),
            ('message', self.gf('django.db.models.fields.TextField')(max_length=16384)),
            ('hotfix', self.gf('django.db.models.fields.BooleanField')(default=False)),
        ))
        db.send_create_signal('svnlog', ['SvnLog'])

        # Adding model 'SvnBranch'
        db.create_table('svnlog_svnbranch', (
            ('branch_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('path', self.gf('django.db.models.fields.CharField')(unique=True, max_length=128)),
        ))
        db.send_create_signal('svnlog', ['SvnBranch'])

        # Adding model 'SvnLogBranch'
        db.create_table('svnlog_svnlogbranch', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('rev', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnLog'], db_column='rev')),
            ('branch', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnBranch'])),
        ))
        db.send_create_signal('svnlog', ['SvnLogBranch'])

        # Adding unique constraint on 'SvnLogBranch', fields ['rev', 'branch']
        db.create_unique('svnlog_svnlogbranch', ['rev', 'branch_id'])

        # Adding model 'SvnPath'
        db.create_table('svnlog_svnpath', (
            ('path_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('path_hash', self.gf('django.db.models.fields.CharField')(unique=True, max_length=64)),
            ('path', self.gf('django.db.models.fields.CharField')(max_length=1000)),
        ))
        db.send_create_signal('svnlog', ['SvnPath'])

        # Adding model 'SvnDiff'
        db.create_table('svnlog_svndiff', (
            ('diff_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('rev', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnLog'], db_column='rev')),
            ('path', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnPath'], db_column='path_id')),
            ('action', self.gf('django.db.models.fields.CharField')(max_length=1, null=True)),
            ('copyfrom_path', self.gf('django.db.models.fields.CharField')(max_length=200, null=True)),
            ('copyfrom_rev', self.gf('django.db.models.fields.related.ForeignKey')(related_name='copyfrom_revs', null=True, db_column='copyfrom_rev', to=orm['svnlog.SvnLog'])),
            ('lines_added', self.gf('django.db.models.fields.PositiveSmallIntegerField')(default=0)),
            ('lines_deleted', self.gf('django.db.models.fields.PositiveSmallIntegerField')(default=0)),
            ('diff', self.gf('django.db.models.fields.TextField')(max_length=34359738368, null=True)),
        ))
        db.send_create_signal('svnlog', ['SvnDiff'])

        # Adding unique constraint on 'SvnDiff', fields ['rev', 'path']
        db.create_unique('svnlog_svndiff', ['rev', 'path_id'])

        # Adding model 'SvnLogHotfix'
        db.create_table('svnlog_svnloghotfix', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('hotfix_rev', self.gf('django.db.models.fields.related.ForeignKey')(related_name='hotfix_releases_set', db_column='hotfix_rev', to=orm['svnlog.SvnLog'])),
            ('release_rev', self.gf('django.db.models.fields.related.ForeignKey')(related_name='release_hotfixes_set', db_column='release_rev', to=orm['svnlog.SvnLog'])),
            ('commit_rev', self.gf('django.db.models.fields.related.ForeignKey')(related_name='hotfix_commits_set', db_column='commit_rev', to=orm['svnlog.SvnLog'])),
        ))
        db.send_create_signal('svnlog', ['SvnLogHotfix'])

        # Adding unique constraint on 'SvnLogHotfix', fields ['hotfix_rev', 'release_rev']
        db.create_unique('svnlog_svnloghotfix', ['hotfix_rev', 'release_rev'])

        # Adding unique constraint on 'SvnLogHotfix', fields ['release_rev', 'hotfix_rev']
        db.create_unique('svnlog_svnloghotfix', ['release_rev', 'hotfix_rev'])

    def backwards(self, orm):

        # Removing unique constraint on 'SvnLogHotfix', fields ['release_rev', 'hotfix_rev']
        db.delete_unique('svnlog_svnloghotfix', ['release_rev', 'hotfix_rev'])

        # Removing unique constraint on 'SvnLogHotfix', fields ['hotfix_rev', 'release_rev']
        db.delete_unique('svnlog_svnloghotfix', ['hotfix_rev', 'release_rev'])

        # Removing unique constraint on 'SvnDiff', fields ['rev', 'path']
        db.delete_unique('svnlog_svndiff', ['rev', 'path_id'])

        # Removing unique constraint on 'SvnLogBranch', fields ['rev', 'branch']
        db.delete_unique('svnlog_svnlogbranch', ['rev', 'branch_id'])

        # Deleting model 'SvnAuthor'
        db.delete_table('svnlog_svnauthor')

        # Deleting model 'SvnLog'
        db.delete_table('svnlog_svnlog')

        # Deleting model 'SvnBranch'
        db.delete_table('svnlog_svnbranch')

        # Deleting model 'SvnLogBranch'
        db.delete_table('svnlog_svnlogbranch')

        # Deleting model 'SvnPath'
        db.delete_table('svnlog_svnpath')

        # Deleting model 'SvnDiff'
        db.delete_table('svnlog_svndiff')

        # Deleting model 'SvnLogHotfix'
        db.delete_table('svnlog_svnloghotfix')

    models = {
        'svnlog.svnauthor': {
            'Meta': {'object_name': 'SvnAuthor'},
            'author_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        },
        'svnlog.svnbranch': {
            'Meta': {'object_name': 'SvnBranch'},
            'branch_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'path': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        },
        'svnlog.svndiff': {
            'Meta': {'unique_together': "(('rev', 'path'),)", 'object_name': 'SvnDiff'},
            'action': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True'}),
            'copyfrom_path': ('django.db.models.fields.CharField', [], {'max_length': '200', 'null': 'True'}),
            'copyfrom_rev': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'copyfrom_revs'", 'null': 'True', 'db_column': "'copyfrom_rev'", 'to': "orm['svnlog.SvnLog']"}),
            'diff': ('django.db.models.fields.TextField', [], {'max_length': '34359738368', 'null': 'True'}),
            'diff_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'lines_added': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'}),
            'lines_deleted': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'}),
            'path': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnPath']", 'db_column': "'path_id'"}),
            'rev': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnLog']", 'db_column': "'rev'"})
        },
        'svnlog.svnlog': {
            'Meta': {'object_name': 'SvnLog'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnAuthor']"}),
            'hotfix': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'message': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'rev': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'}),
            'revtime': ('django.db.models.fields.DateTimeField', [], {})
        },
        'svnlog.svnlogbranch': {
            'Meta': {'unique_together': "(('rev', 'branch'),)", 'object_name': 'SvnLogBranch'},
            'branch': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnBranch']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'rev': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnLog']", 'db_column': "'rev'"})
        },
        'svnlog.svnloghotfix': {
            'Meta': {'unique_together': "(('hotfix_rev', 'release_rev'), ('release_rev', 'hotfix_rev'))", 'object_name': 'SvnLogHotfix'},
            'commit_rev': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'hotfix_commits_set'", 'db_column': "'commit_rev'", 'to': "orm['svnlog.SvnLog']"}),
            'hotfix_rev': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'hotfix_releases_set'", 'db_column': "'hotfix_rev'", 'to': "orm['svnlog.SvnLog']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'release_rev': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'release_hotfixes_set'", 'db_column': "'release_rev'", 'to': "orm['svnlog.SvnLog']"})
        },
        'svnlog.svnpath': {
            'Meta': {'object_name': 'SvnPath'},
            'path': ('django.db.models.fields.CharField', [], {'max_length': '1000'}),
            'path_hash': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '64'}),
            'path_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['svnlog']
