# -*- encoding: utf-8 -*-
from django.db import models

import hashlib, base64

#class SvnProjects(models.Model):
#    project_id = models.AutoField(primary_key=True, )
#    name = models.CharField(max_length=128, )

class SvnAuthor(models.Model):
    author_id = models.AutoField(primary_key=True, )
    login = models.CharField(max_length=128, unique=True, )
    def __unicode__(self):
        return 'id: %d, login: %s ' % (self.author_id, self.login)

class SvnLog(models.Model):
    rev = models.IntegerField(primary_key=True, )
    revtime = models.DateTimeField()
    author = models.ForeignKey('SvnAuthor')
    message = models.TextField(max_length=16384, )
    hotfix = models.BooleanField(default=False)
    def __unicode__(self):
        return 'r%d, %s, author=%s, %s' % (self.rev, self.revtime, self.author.login, self.message.rstrip())

class SvnBranch(models.Model):
    branch_id = models.AutoField(primary_key=True, )
    path = models.CharField(max_length=128, unique=True, )

class SvnLogBranch(models.Model):
    rev = models.ForeignKey('SvnLog', db_column='rev', )
    branch = models.ForeignKey('SvnBranch')
    class Meta:
        unique_together = (('rev', 'branch'), )

class SvnPath(models.Model):
    path_id = models.AutoField(primary_key=True, )
    path_hash = models.CharField(max_length=64, unique=True, )
    path = models.CharField(max_length=1000, )
    @classmethod
    def hash(cls, str):
        h = hashlib.sha256()
        h.update(str)
        return base64.b64encode(h.digest())

class SvnDiff(models.Model):
    diff_id = models.AutoField(primary_key=True, )
    rev = models.ForeignKey('SvnLog', db_column='rev', )
    path = models.ForeignKey('SvnPath', db_column='path_id', )
    action = models.CharField(max_length=1, null=True)
    copyfrom_path = models.CharField(max_length=200, null=True)
    copyfrom_rev = models.IntegerField(null=True)
    lines_added = models.PositiveSmallIntegerField(default=0)
    lines_deleted = models.PositiveSmallIntegerField(default=0)
    # потом - заоптимизировать до diff_compressed
    diff = models.TextField(max_length=32*1024*1024*1024, null=True)
    def __unicode__(self):
        return 'rev: %d, path: %s, lines_changed: %d, diff_len: %d' % (self.rev.rev, self.path, self.lines_added+self.lines_deleted, len(self.diff))
    class Meta:
        unique_together = (('rev', 'path'), )

class SvnLogHotfix(models.Model):
    hotfix_rev = models.ForeignKey('SvnLog', db_column='hotfix_rev', related_name='hotfix_releases_set')
    release_rev = models.ForeignKey('SvnLog', db_column='release_rev', related_name='release_hotfixes_set')
    commit_rev = models.ForeignKey('SvnLog', db_column='commit_rev', related_name='hotfix_commits_set')
    class Meta:
        unique_together = (('hotfix_rev', 'release_rev'), ('release_rev', 'hotfix_rev'), )

