import re

from django import template
from django.template.defaultfilters import stringfilter
from django.utils.safestring import mark_safe
from django.utils.html import escape
import math

from django.conf import settings
from releaser.utils import make_display_url

register = template.Library()

@register.filter
def svnlog_format_message(value):
    lines = value.strip().split("\n")
    processed_lines = []
    for line in lines:
        line = escape(line)
        m = re.search(settings.ISSUE_KEY_REGEXP, line)
        if m:
            issue_key = m.groups()[0]
            line = line.replace(issue_key, u'<a class="jLink" href="%s">%s</a>' % (make_display_url(issue_key), issue_key))
        line = re.sub(r'^(RELEASE:.*)', r'<span class="jHotFix">\1</span>', line)
        processed_lines.append(line)
    return mark_safe("<br>".join(filter(lambda l: l!='',processed_lines)))

@register.filter
def svnlog_changes_width(val, dim=1):
    return int(dim * math.log(1 + val, 1.2) + 0.5)

