# -* encoding: utf-8 -*-

from django.db.models import Q
import math, re, sys

from django.conf import settings
from releaser.svnlog.models import *
from releaser.svnrelease.models import *

from releaser.utils import calc_font_size
from releaser.versionica.models import HostGroup
from releaser.versionica.installed_versions import check_commits
from releaser.releaseplanning.models import TaskToRelease
from releaser.releaseplanning.tools import *
from releaser.hotfixing.models import HotfixRequest
from releaser.releaseplanning.tasks import get_recent_tasks, tasks_waiting_for_release


"""
Последние limit релизов
"""
def get_recent_releases(limit, app_id=None):
    releases = SvnRelease.objects.all()
    if app_id != None:
        releases = releases.filter(app_id=app_id)
    releases = list(releases.order_by('-base_rev')[:limit])
    return releases

"""
Базовая ревизия нового (несозданного релиза)
"""
def get_new_release_base(app_id=0):
    releases_list = get_recent_releases(1,app_id=app_id)
    last_release_base = releases_list[0].base_rev if len(releases_list) > 0 else 0
    return last_release_base


def get_svnlog_stat(commits=[]):
    stat = {
            'commits': 0,
            'commits_deployed': 0,
            'commits_new': 0,
            'commits_mentioned': 0,
            'mentioned': 0,
            }

    try:
        prod = HostGroup.objects.get(name='production')
    except HostGroup.DoesNotExist:
        return stat

    new_release = False
    if len(commits) == 0:
        new_release = True
        commits = SvnLog.objects.filter(svnlogbranch__branch__path = settings.SVN_DEFAULT_BRANCH, rev__gt=get_new_release_base())

    commits_existence = check_commits(prod, [c.rev for c in commits])
    commits_deployed = [c for c in commits if commits_existence[c.rev]]
    if new_release:
        mentioned = tasks_waiting_for_release()
    else:
        rev_list = [c.rev for c in commits]
        tasks = TaskToRelease.objects.filter(commit__in=rev_list )
        tasks_uniq = dict(map(lambda i: (i.jira_issue,i),tasks)).values()
        mentioned = [t.title if not too_long_title(t.title) else (u"Слишком длинное название задачи. Исправь сейчас!") for t in tasks_uniq]

    stat = {
            'commits': len(commits),
            'commits_deployed': len(commits_deployed),
            'commits_new': len(commits) - len(commits_deployed),
            'commits_mentioned': len(mentioned),
            'mentioned': mentioned,
            }
    stat['commits_font_size'] = calc_font_size(stat['commits'], 20, 1.5, 40)
    stat['commits_deployed_font_size'] = calc_font_size(stat['commits_deployed'], 7, 2, 50)
    stat['commits_new_font_size'] = calc_font_size(stat['commits_new'], 20, 1.5, 40)
    stat['commits_mentioned_font_size'] = calc_font_size(stat['commits_mentioned'], 0.3, 1.4, 30, 80)

    return stat
