# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'SvnRelease'
        db.create_table('svnrelease_svnrelease', (
            ('release_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('jira_id', self.gf('django.db.models.fields.CharField')(unique=True, max_length=20)),
            ('jira_status', self.gf('django.db.models.fields.CharField')(max_length=40)),
            ('create_time', self.gf('django.db.models.fields.DateTimeField')()),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=256)),
            ('base_rev', self.gf('django.db.models.fields.IntegerField')()),
            ('tip_rev', self.gf('django.db.models.fields.IntegerField')()),
            ('deploy', self.gf('django.db.models.fields.TextField')(max_length=16384)),
            ('deploy_notes', self.gf('django.db.models.fields.TextField')(max_length=16384)),
        ))
        db.send_create_signal('svnrelease', ['SvnRelease'])

    def backwards(self, orm):

        # Deleting model 'SvnRelease'
        db.delete_table('svnrelease_svnrelease')

    models = {
        'svnrelease.svnrelease': {
            'Meta': {'object_name': 'SvnRelease'},
            'base_rev': ('django.db.models.fields.IntegerField', [], {}),
            'create_time': ('django.db.models.fields.DateTimeField', [], {}),
            'deploy': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'deploy_notes': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'jira_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'jira_status': ('django.db.models.fields.CharField', [], {'max_length': '40'}),
            'release_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tip_rev': ('django.db.models.fields.IntegerField', [], {}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '256'})
        }
    }

    complete_apps = ['svnrelease']
