from django.db import models
from releaser.utils import make_display_url

class SvnRelease(models.Model):
    release_id = models.AutoField(primary_key=True, )
    app_id = models.IntegerField(default=0)
    jira_id = models.CharField(max_length=20, unique=True, )
    jira_status = models.CharField(max_length=40, )
    create_time = models.DateTimeField()
    title = models.CharField(max_length=256, )
    base_rev = models.IntegerField()
    tip_rev = models.IntegerField()
    deploy = models.TextField(max_length=16384, )
    deploy_notes = models.TextField(max_length=16384, )
    def __unicode__(self):
        return 'rel_id: %d, 1.%d.%d-1, %s' % (self.release_id, self.base_rev, self.tip_rev, self.title)
    def display_url(self):
        return make_display_url(self.jira_id)
